/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.parser.sequentialparsers.DelimiterParser;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.markdown.parser.sequentialparsers.TokensCache;
import org.intellij.markdown.parser.sequentialparsers.impl.EmphStrongDelimiterParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/intellij/markdown/flavours/gfm/StrikeThroughDelimiterParser;", "Lorg/intellij/markdown/parser/sequentialparsers/DelimiterParser;", "()V", "process", "", "tokens", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache;", "iterator", "Lorg/intellij/markdown/parser/sequentialparsers/TokensCache$Iterator;", "delimiters", "", "Lorg/intellij/markdown/parser/sequentialparsers/DelimiterParser$Info;", "result", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$ParsingResultBuilder;", "scan", "", "markdown"})
public final class StrikeThroughDelimiterParser
extends DelimiterParser {
    @Override
    public int scan(@NotNull TokensCache tokens, @NotNull TokensCache.Iterator iterator, @NotNull List<DelimiterParser.Info> delimiters) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        Intrinsics.checkNotNullParameter(delimiters, (String)"delimiters");
        if (!Intrinsics.areEqual((Object)iterator.getType(), (Object)GFMTokenTypes.TILDE)) {
            return 0;
        }
        int stepsToAdvance = 1;
        TokensCache.Iterator rightIterator = iterator;
        for (int index = 0; index < 50 && Intrinsics.areEqual((Object)rightIterator.rawLookup(1), (Object)GFMTokenTypes.TILDE); ++index) {
            rightIterator = rightIterator.advance();
            ++stepsToAdvance;
        }
        Pair<Boolean, Boolean> pair = this.canOpenClose(tokens, iterator, rightIterator, true);
        boolean canOpen = (Boolean)pair.component1();
        boolean canClose = (Boolean)pair.component2();
        int n = stepsToAdvance;
        for (int index = 0; index < n; ++index) {
            DelimiterParser.Info info = new DelimiterParser.Info(GFMTokenTypes.TILDE, iterator.getIndex() + index, 0, canOpen, canClose, '~', 0, 64, null);
            delimiters.add(info);
        }
        return stepsToAdvance;
    }

    @Override
    public void process(@NotNull TokensCache tokens, @NotNull TokensCache.Iterator iterator, @NotNull List<DelimiterParser.Info> delimiters, @NotNull SequentialParser.ParsingResultBuilder result) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        Intrinsics.checkNotNullParameter(delimiters, (String)"delimiters");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        boolean shouldSkipNext = false;
        int n = delimiters.size() + -1;
        if (0 <= n) {
            do {
                int index = n--;
                if (shouldSkipNext) {
                    shouldSkipNext = false;
                    continue;
                }
                DelimiterParser.Info opener = delimiters.get(index);
                if (!Intrinsics.areEqual((Object)opener.getTokenType(), (Object)GFMTokenTypes.TILDE) || opener.getCloserIndex() == -1) continue;
                shouldSkipNext = EmphStrongDelimiterParser.Companion.areAdjacentSameMarkers(delimiters, index, opener.getCloserIndex());
                DelimiterParser.Info closer = delimiters.get(opener.getCloserIndex());
                if (!shouldSkipNext) continue;
                SequentialParser.Node node = new SequentialParser.Node(new IntRange(opener.getPosition() - 1, closer.getPosition() + 2), GFMElementTypes.STRIKETHROUGH);
                result.withNode(node);
            } while (0 <= n);
        }
    }
}

