/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.rules.tree.HintableFeature;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PatternHint(List<Disjunct> disjuncts) {
    static final PatternHint ALLOW_ANYTHING = new PatternHint(List.of(Disjunct.ALLOW_ANYTHING));

    public boolean allowsEverything() {
        return this == ALLOW_ANYTHING;
    }

    PatternHint withNodeForms(@Nullable Set<String> possible) {
        if (possible == null) {
            return this;
        }
        return this.and(new PatternHint(List.of(new Disjunct((String[])possible.stream().map(s -> s.toLowerCase(Locale.ROOT)).distinct().sorted().toArray(String[]::new), null, null, null, null, null, null))));
    }

    PatternHint withNodeLemmas(@Nullable Set<String> possible) {
        if (possible == null) {
            return this;
        }
        return this.and(new PatternHint(List.of(new Disjunct(null, null, (String[])possible.stream().map(s -> s.toLowerCase(Locale.ROOT)).distinct().sorted().toArray(String[]::new), null, null, null, null))));
    }

    PatternHint withHeadRelations(@Nullable Set<String> possible) {
        if (possible == null) {
            return this;
        }
        return this.and(new PatternHint(List.of(new Disjunct(null, null, null, null, (String[])possible.stream().sorted().toArray(String[]::new), null, null))));
    }

    PatternHint withDependentRelations(@Nullable Set<String> possible) {
        if (possible == null) {
            return this;
        }
        return this.and(new PatternHint(List.of(new Disjunct(null, null, null, null, null, (String[])possible.stream().sorted().toArray(String[]::new), null))));
    }

    PatternHint withNodeSubstrings(String @NotNull [] possible) {
        if (possible.length == 0 || Arrays.asList(possible).contains("")) {
            throw new IllegalArgumentException("Substring hints should not be empty");
        }
        return this.and(new PatternHint(List.of(new Disjunct(null, null, null, null, null, null, (String[])Arrays.stream(possible).sorted().toArray(String[]::new)))));
    }

    PatternHint withAnotherNode(PatternHint another) {
        if (another == ALLOW_ANYTHING) {
            return this;
        }
        return this.and(new PatternHint(((StreamEx)StreamEx.of(another.disjuncts).map(Disjunct::moveToAnotherNode).distinct()).toList()));
    }

    PatternHint and(PatternHint hint) {
        if (hint == ALLOW_ANYTHING) {
            return this;
        }
        return PatternHint.orEmpty(new PatternHint(((StreamEx)StreamEx.of(this.disjuncts).flatMap(d1 -> StreamEx.of(hint.disjuncts).map(d2 -> Disjunct.and(d1, d2)).nonNull()).distinct()).toList()));
    }

    private static PatternHint orEmpty(PatternHint result) {
        return result.disjuncts.contains(Disjunct.ALLOW_ANYTHING) ? ALLOW_ANYTHING : result;
    }

    static PatternHint or(List<PatternHint> disjuncts) {
        if (disjuncts.isEmpty()) {
            return ALLOW_ANYTHING;
        }
        return PatternHint.orEmpty(new PatternHint(((StreamEx)StreamEx.of(disjuncts).flatCollection(PatternHint::disjuncts).distinct()).toList()));
    }

    record Disjunct(String @Nullable [] nodeForm, String @Nullable [] someForm, String @Nullable [] nodeLemma, String @Nullable [] someLemma, String @Nullable [] headRel, String @Nullable [] depRel, String @Nullable [] nodeSubstring) {
        private static final Disjunct ALLOW_ANYTHING = new Disjunct(null, null, null, null, null, null, null);

        List<HintableFeature> bestOwnFeatures() {
            if (this.nodeForm != null) {
                return Arrays.stream(this.nodeForm).map(f -> HintableFeature.create(1, f)).toList();
            }
            if (this.nodeLemma != null) {
                return Arrays.stream(this.nodeLemma).map(f -> HintableFeature.create(2, f)).toList();
            }
            if (this.headRel != null) {
                return Arrays.stream(this.headRel).map(f -> HintableFeature.create(4, f)).toList();
            }
            if (this.depRel != null) {
                return Arrays.stream(this.depRel).map(f -> HintableFeature.create(8, f)).toList();
            }
            return List.of();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Disjunct)) {
                return false;
            }
            Disjunct disjunct = (Disjunct)o;
            return Arrays.equals(this.depRel, disjunct.depRel) && Arrays.equals(this.headRel, disjunct.headRel) && Arrays.equals(this.nodeForm, disjunct.nodeForm) && Arrays.equals(this.someForm, disjunct.someForm) && Arrays.equals(this.nodeLemma, disjunct.nodeLemma) && Arrays.equals(this.someLemma, disjunct.someLemma) && Arrays.equals(this.nodeSubstring, disjunct.nodeSubstring);
        }

        @Override
        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.nodeForm), Arrays.hashCode(this.someForm), Arrays.hashCode(this.nodeLemma), Arrays.hashCode(this.someLemma), Arrays.hashCode(this.headRel), Arrays.hashCode(this.depRel), Arrays.hashCode(this.nodeSubstring));
        }

        @Override
        public String toString() {
            return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.NO_CLASS_NAME_STYLE, (boolean)false, (boolean)false, (boolean)true, Object.class);
        }

        Disjunct moveToAnotherNode() {
            return Objects.requireNonNull(Disjunct.and(new Disjunct(null, this.someForm, null, this.someLemma, null, null, null), new Disjunct(null, this.nodeForm, null, this.nodeLemma, null, null, null)));
        }

        @Nullable
        static Disjunct and(Disjunct d1, Disjunct d2) {
            String[] nodeForm = Disjunct.intersect(d1.nodeForm, d2.nodeForm);
            if (nodeForm != null && nodeForm.length == 0) {
                return null;
            }
            String[] headRel = Disjunct.intersect(d1.headRel, d2.headRel);
            if (headRel != null && headRel.length == 0) {
                return null;
            }
            String[] nodeLemma = Disjunct.preferMoreRestrictive(d1.nodeLemma, d2.nodeLemma);
            String[] someForm = Disjunct.preferMoreRestrictive(d1.someForm, d2.someForm);
            String[] someLemma = Disjunct.preferMoreRestrictive(d1.someLemma, d2.someLemma);
            if (someForm != null && nodeForm != null) {
                someForm = Disjunct.setDifference(someForm, Set.of(nodeForm));
            }
            if (someLemma != null && nodeLemma != null) {
                someLemma = Disjunct.setDifference(someLemma, Set.of(nodeLemma));
            }
            String[] depRel = Disjunct.preferMoreRestrictive(d1.depRel, d2.depRel);
            String[] nodeSubstring = Disjunct.preferMoreRestrictive(d1.nodeSubstring, d2.nodeSubstring);
            return nodeForm == null && someForm == null && nodeLemma == null && someLemma == null && headRel == null && depRel == null && nodeSubstring == null ? ALLOW_ANYTHING : new Disjunct(nodeForm, someForm, nodeLemma, someLemma, headRel, depRel, nodeSubstring);
        }

        private static String @Nullable [] setDifference(String[] someData, Set<String> nodeData) {
            LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(someData));
            set.removeAll(nodeData);
            return set.isEmpty() ? null : set.toArray(new String[0]);
        }

        @Nullable
        private static String[] intersect(String @Nullable [] v1, String @Nullable [] v2) {
            if (v1 == null) {
                return v2;
            }
            if (v2 == null) {
                return v1;
            }
            LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(v1));
            set.retainAll(Arrays.asList(v2));
            return set.toArray(new String[0]);
        }

        @Nullable
        private static String[] preferMoreRestrictive(String @Nullable [] v1, String @Nullable [] v2) {
            if (v1 == null) {
                return v2;
            }
            if (v2 == null) {
                return v1;
            }
            if (Disjunct.areAllLonger(v1, v2)) {
                return v1;
            }
            if (Disjunct.areAllLonger(v2, v1)) {
                return v2;
            }
            return v1.length < v2.length ? v1 : v2;
        }

        static boolean areAllLonger(String @NotNull [] longer, String @NotNull [] shorter) {
            return StreamEx.of((Object[])longer).mapToInt(String::length).min().orElseThrow() > StreamEx.of((Object[])shorter).mapToInt(String::length).max().orElseThrow();
        }
    }
}

