from __future__ import annotations
import collections.abc
import datetime
import typing
from warnings import deprecated # type: ignore

import jpype # type: ignore
import jpype.protocol # type: ignore

import java.awt.event # type: ignore
import java.lang # type: ignore


class MouseBinding(java.lang.Object):
    """
    A simple class that represents a mouse button and any modifiers needed to bind an action to a
    mouse input event.
     
    
    The modifiers used by this class will include the button down mask for the given button.  This
    is done to match how :obj:`MouseEvent` uses its modifiers.
    """

    class_: typing.ClassVar[java.lang.Class]

    @typing.overload
    def __init__(self, button: typing.Union[jpype.JInt, int]):
        """
        Construct a binding with the given button number of the desired mouse button (e.g., 1, 2,...)
        
        :param jpype.JInt or int button: the button number
        """

    @typing.overload
    def __init__(self, button: typing.Union[jpype.JInt, int], modifiers: typing.Union[jpype.JInt, int]):
        """
        Construct a binding with the given button number of the desired mouse button (e.g., 1, 2,...)
        as well as any desired modifiers (e.g., :obj:`InputEvent.SHIFT_DOWN_MASK`).
        
        :param jpype.JInt or int button: the button number
        :param jpype.JInt or int modifiers: the event modifiers
        """

    def getButton(self) -> int:
        """
        The button used by this class
        
        :return: the button used by this class
        :rtype: int
        """

    def getDisplayText(self) -> str:
        """
        A user-friendly display string for this class
        
        :return: a user-friendly display string for this class
        :rtype: str
        """

    def getModifiers(self) -> int:
        """
        The modifiers used by this class
        
        :return: the modifiers used by this class
        :rtype: int
        """

    @staticmethod
    @typing.overload
    def getMouseBinding(e: java.awt.event.MouseEvent) -> MouseBinding:
        """
        Create a mouse binding for the given event
        
        :param java.awt.event.MouseEvent e: the event
        :return: the mouse binding
        :rtype: MouseBinding
        """

    @staticmethod
    @typing.overload
    def getMouseBinding(mouseString: typing.Union[java.lang.String, str]) -> MouseBinding:
        """
        Creates a mouse binding from the given string.  The string is expected to be of the form:
        ``Ctrl+Button1``, which is the form of the text generated by :meth:`getDisplayText() <.getDisplayText>`.
        
        :param java.lang.String or str mouseString: the mouse string
        :return: the mouse binding or null if an invalid string was given
        :rtype: MouseBinding
        """

    def isMatchingRelease(self, e: java.awt.event.MouseEvent) -> bool:
        """
        Returns true if the given mouse event is the mouse released event for the mouse button used
        by this class.  This method will ignore modifier text, since modifiers can be pressed and
        released independent of the mouse button's release.
        
        :param java.awt.event.MouseEvent e: the event
        :return: true if the given mouse event is the mouse released event for the mouse button used
        by this class
        :rtype: bool
        """

    @property
    def matchingRelease(self) -> jpype.JBoolean:
        ...

    @property
    def button(self) -> jpype.JInt:
        ...

    @property
    def displayText(self) -> java.lang.String:
        ...

    @property
    def modifiers(self) -> jpype.JInt:
        ...



__all__ = ["MouseBinding"]
