/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface LayoutStateChange {

    public static interface Listener {
        public void layoutStateChanged(Event var1);
    }

    public static class Event {
        public final LayoutModel layoutModel;
        public final boolean active;

        public Event(LayoutModel layoutModel, boolean active) {
            this.layoutModel = layoutModel;
            this.active = active;
        }

        public String toString() {
            return "LayoutStateChange.Event{layoutModel=" + this.layoutModel + ", active=" + this.active + "}";
        }
    }

    public static class SupportImpl
    implements Support {
        private final Logger log = LoggerFactory.getLogger(SupportImpl.class);
        protected boolean fireEvents = true;
        protected List<Listener> changeListeners = Collections.synchronizedList(new ArrayList());

        private SupportImpl() {
        }

        @Override
        public boolean isFireEvents() {
            return this.fireEvents;
        }

        @Override
        public void setFireEvents(boolean fireEvents) {
            this.log.trace("setFireEvents({})", (Object)fireEvents);
            this.fireEvents = fireEvents;
        }

        @Override
        public void addLayoutStateChangeListener(Listener l) {
            this.changeListeners.add(l);
        }

        @Override
        public void removeLayoutStateChangeListener(Listener l) {
            this.changeListeners.remove(l);
        }

        @Override
        public List<Listener> getLayoutStateChangeListeners() {
            return this.changeListeners;
        }

        @Override
        public void fireLayoutStateChanged(LayoutModel layoutModel, boolean state) {
            if (this.fireEvents && this.changeListeners.size() > 0) {
                this.log.trace("fireLayoutStateChanged :{}", (Object)state);
                Event evt = new Event(layoutModel, state);
                for (int i = this.changeListeners.size() - 1; i >= 0; --i) {
                    this.changeListeners.get(i).layoutStateChanged(evt);
                }
            }
        }
    }

    public static interface Support {
        public static Support create() {
            return new SupportImpl();
        }

        public boolean isFireEvents();

        public void setFireEvents(boolean var1);

        public void addLayoutStateChangeListener(Listener var1);

        public void removeLayoutStateChangeListener(Listener var1);

        public List<Listener> getLayoutStateChangeListeners();

        public void fireLayoutStateChanged(LayoutModel var1, boolean var2);
    }

    public static interface Producer {
        public Support getLayoutStateChangeSupport();
    }
}

