/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;

public abstract class AbstractSkipMsType
extends AbstractMsType {
    protected RecordNumber nextValidRecordNumber;
    protected int recordLength;

    public AbstractSkipMsType(AbstractPdb pdb, PdbByteReader reader, int recordNumberSize) throws PdbException {
        super(pdb, reader);
        this.nextValidRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.recordLength = reader.getLimit() - reader.getIndex();
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append(String.format("Skip Record, nextValidTypeIndex = 0x%x, Length = 0x%x", this.nextValidRecordNumber.getNumber(), this.recordLength));
    }
}

