/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;

public class StartSearchMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 5;
    private long startSym;
    private int segment;

    public StartSearchMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.startSym = reader.parseUnsignedIntVal();
        this.segment = pdb.parseSegment(reader);
    }

    @Override
    public int getPdbId() {
        return 5;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("Start search for segment 0x%X at 0x%X", this.segment, this.startSym));
    }

    @Override
    protected String getSymbolTypeName() {
        return "START_SEARCH";
    }
}

