/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ISF.IsfObject;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import sarif.export.data.ExtIsfDataTypeWriter;
import sarif.export.data.SarifDataType;

public class SarifDataTypeWriter
extends ExtIsfDataTypeWriter {
    private JsonArray types = new JsonArray();

    public SarifDataTypeWriter(DataTypeManager dtm, List<DataType> target, Writer baseWriter) throws IOException {
        super(dtm, target, baseWriter);
        this.metadata = new JsonObject();
        this.baseTypes = this.types;
        this.userTypes = this.types;
        this.enums = this.types;
        this.functions = this.types;
        this.symbols = new JsonObject();
    }

    protected void addSingletons() {
        this.add(this.baseTypes, "pointer", this.getTree(new SarifDataType((IsfObject)this.newTypedefPointer(null), this)));
        this.add(this.baseTypes, "undefined", this.getTree(new SarifDataType((IsfObject)this.newTypedefPointer(null), this)));
    }

    protected JsonObject getObjectForDataType(DataType dt, TaskMonitor monitor) throws IOException, CancelledException {
        SarifDataType isf = new SarifDataType(this.getIsfObject(dt, monitor), this);
        JsonObject jobj = (JsonObject)this.getTree(isf);
        this.resolved.put(dt, isf);
        return jobj;
    }

    public JsonArray getResults() {
        return this.types;
    }
}

