/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcode;

import ghidra.app.plugin.processors.sleigh.template.ConstTpl;
import ghidra.app.plugin.processors.sleigh.template.OpTpl;
import ghidra.app.plugin.processors.sleigh.template.VarnodeTpl;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.lang.Language;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public interface PcodeFormatter<T> {
    default public T formatOps(Language language, List<PcodeOp> pcodeOps) {
        return this.formatOps(language, language.getAddressFactory(), pcodeOps);
    }

    default public T formatOps(Language language, AddressFactory addrFactory, List<PcodeOp> pcodeOps) {
        return this.formatTemplates(language, PcodeFormatter.getPcodeOpTemplates(addrFactory, pcodeOps));
    }

    public T formatTemplates(Language var1, List<OpTpl> var2);

    public static List<OpTpl> getPcodeOpTemplates(AddressFactory addrFactory, List<PcodeOp> pcodeOps) {
        ArrayList<OpTpl> list = new ArrayList<OpTpl>();
        HashMap<Integer, Integer> labelMap = new HashMap<Integer, Integer>();
        for (int seq = 0; seq < pcodeOps.size(); ++seq) {
            PcodeOp pcodeOp = pcodeOps.get(seq);
            int opcode = pcodeOp.getOpcode();
            VarnodeTpl outputTpl = null;
            Varnode v = pcodeOp.getOutput();
            if (v != null) {
                outputTpl = PcodeFormatter.getVarnodeTpl(addrFactory, v);
            }
            Varnode[] inputs = pcodeOp.getInputs();
            VarnodeTpl[] inputTpls = new VarnodeTpl[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                Varnode input = inputs[i];
                if (i == 0 && (opcode == 4 || opcode == 5) && input.isConstant()) {
                    int labelIndex;
                    int labelOffset = seq + (int)input.getOffset();
                    if (labelMap.containsKey(labelOffset)) {
                        labelIndex = (Integer)labelMap.get(labelOffset);
                    } else {
                        labelIndex = labelMap.size();
                        labelMap.put(labelOffset, labelIndex);
                    }
                    ConstTpl offsetTpl = new ConstTpl(8, labelIndex);
                    ConstTpl spaceTpl = new ConstTpl(addrFactory.getConstantSpace());
                    ConstTpl sizeTpl = new ConstTpl(0, 8L);
                    inputTpls[i] = new VarnodeTpl(spaceTpl, offsetTpl, sizeTpl);
                    continue;
                }
                inputTpls[i] = PcodeFormatter.getVarnodeTpl(addrFactory, input);
            }
            list.add(new OpTpl(opcode, outputTpl, inputTpls));
        }
        ArrayList offsetList = new ArrayList(labelMap.keySet());
        Collections.sort(offsetList);
        for (int i = offsetList.size() - 1; i >= 0; --i) {
            int labelOffset = (Integer)offsetList.get(i);
            if (labelOffset > pcodeOps.size()) continue;
            int labelIndex = (Integer)labelMap.get(labelOffset);
            OpTpl labelTpl = PcodeFormatter.getLabelOpTemplate(addrFactory, labelIndex);
            list.add(labelOffset, labelTpl);
        }
        return list;
    }

    private static OpTpl getLabelOpTemplate(AddressFactory addrFactory, int labelIndex) {
        ConstTpl offsetTpl = new ConstTpl(0, labelIndex);
        ConstTpl spaceTpl = new ConstTpl(addrFactory.getConstantSpace());
        ConstTpl sizeTpl = new ConstTpl(0, 8L);
        VarnodeTpl input = new VarnodeTpl(spaceTpl, offsetTpl, sizeTpl);
        return new OpTpl(65, null, new VarnodeTpl[]{input});
    }

    private static VarnodeTpl getVarnodeTpl(AddressFactory addrFactory, Varnode v) {
        ConstTpl offsetTpl = new ConstTpl(0, v.getOffset());
        ConstTpl spaceTpl = new ConstTpl(v.getAddress().getAddressSpace());
        ConstTpl sizeTpl = new ConstTpl(0, v.getSize());
        return new VarnodeTpl(spaceTpl, offsetTpl, sizeTpl);
    }
}

