/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external;

import ghidra.app.util.bin.format.dwarf.external.ExternalDebugInfo;
import ghidra.app.util.bin.format.dwarf.external.SearchLocation;
import ghidra.app.util.bin.format.dwarf.external.SearchLocationCreatorContext;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.CRC32;

public class LocalDirectorySearchLocation
implements SearchLocation {
    private static final String LOCAL_DIR_PREFIX = "dir://";
    private final File searchDir;

    public static boolean isLocalDirSearchLoc(String locString) {
        return locString.startsWith(LOCAL_DIR_PREFIX);
    }

    public static LocalDirectorySearchLocation create(String locString, SearchLocationCreatorContext context) {
        locString = locString.substring(LOCAL_DIR_PREFIX.length());
        return new LocalDirectorySearchLocation(new File(locString));
    }

    public LocalDirectorySearchLocation(File searchDir) {
        this.searchDir = searchDir;
    }

    @Override
    public String getName() {
        return LOCAL_DIR_PREFIX + this.searchDir.getPath();
    }

    @Override
    public String getDescriptiveName() {
        return this.searchDir.getPath();
    }

    @Override
    public FSRL findDebugFile(ExternalDebugInfo debugInfo, TaskMonitor monitor) throws CancelledException, IOException {
        if (!debugInfo.hasFilename()) {
            return null;
        }
        this.ensureSafeFilename(debugInfo.getFilename());
        return this.findFile(this.searchDir, debugInfo, monitor);
    }

    private void ensureSafeFilename(String filename) throws IOException {
        File testFile = new File(this.searchDir, filename);
        if (!this.searchDir.equals(testFile.getParentFile())) {
            throw new IOException("Unsupported path specified in debug file: " + filename);
        }
    }

    FSRL findFile(File dir, ExternalDebugInfo debugInfo, TaskMonitor monitor) throws IOException, CancelledException {
        File[] subDirs;
        if (!debugInfo.hasFilename()) {
            return null;
        }
        File file = new File(dir, debugInfo.getFilename());
        if (file.isFile()) {
            int fileCRC = LocalDirectorySearchLocation.calcCRC(file);
            if (fileCRC == debugInfo.getCrc()) {
                return FileSystemService.getInstance().getLocalFSRL(file);
            }
            Msg.info((Object)this, (Object)("DWARF external debug file found with mismatching crc, ignored: " + String.valueOf(file) + ", (" + Integer.toHexString(fileCRC) + ")"));
        }
        if ((subDirs = dir.listFiles(f -> f.isDirectory())) != null) {
            for (File subDir : subDirs) {
                FSRL result = this.findFile(subDir, debugInfo, monitor);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static int calcCRC(File f) throws IOException {
        byte[] bytes = new byte[65536];
        CRC32 crc32 = new CRC32();
        try (FileInputStream fis = new FileInputStream(f);){
            int bytesRead;
            while ((bytesRead = fis.read(bytes)) > 0) {
                crc32.update(bytes, 0, bytesRead);
            }
        }
        return (int)crc32.getValue();
    }
}

