/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.InvalidFileArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DtFilterState;
import ghidra.program.model.data.ArchiveType;
import ghidra.util.HTMLUtilities;
import java.util.List;

public class InvalidArchiveNode
extends ArchiveNode {
    public InvalidArchiveNode(InvalidFileArchive archive) {
        super(archive, new DtFilterState());
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return false;
    }

    @Override
    public String getToolTip() {
        ArchiveType archiveType = ((InvalidFileArchive)this.archive).getArchiveType();
        String type = archiveType == ArchiveType.FILE ? "File" : "Project";
        return "<html>Unable to locate " + type + " data type archive: " + HTMLUtilities.escapeHTML((String)this.archive.getName());
    }

    @Override
    public String getName() {
        return this.archive.getName();
    }

    @Override
    public boolean canCut() {
        return false;
    }

    @Override
    public boolean canPaste(List<GTreeNode> pastedNodes) {
        return false;
    }

    @Override
    public ArchiveNode getArchiveNode() {
        return null;
    }

    @Override
    public boolean isCut() {
        return false;
    }

    @Override
    public boolean canDelete() {
        return false;
    }

    @Override
    public void setNodeCut(boolean isCut) {
    }

    @Override
    public Archive getArchive() {
        return this.archive;
    }
}

