/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.emulation;

import ghidra.pcode.emulate.Emulate;
import ghidra.pcode.emulate.EmulateInstructionStateModifier;
import ghidra.pcode.emulate.callother.OpBehaviorOther;
import ghidra.pcode.error.LowlevelError;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.pcode.Varnode;
import java.math.BigInteger;

public class ARMEmulateInstructionStateModifier
extends EmulateInstructionStateModifier {
    private Register TModeReg;
    private Register TBreg;
    private RegisterValue tMode;
    private RegisterValue aMode;

    public ARMEmulateInstructionStateModifier(Emulate emu) {
        super(emu);
        this.TModeReg = this.language.getRegister("TMode");
        this.TBreg = this.language.getRegister("ISAModeSwitch");
        if (this.TModeReg != null) {
            if (this.TBreg == null) {
                throw new RuntimeException("Expected language " + String.valueOf(this.language.getLanguageID()) + " to have ISAModeSwitch register defined");
            }
            this.tMode = new RegisterValue(this.TModeReg, BigInteger.ONE);
            this.aMode = new RegisterValue(this.TModeReg, BigInteger.ZERO);
        }
        this.registerPcodeOpBehavior("setISAMode", new SetISAModeOpBehavior());
    }

    public void initialExecuteCallback(Emulate emulate, Address current_address, RegisterValue contextRegisterValue) throws LowlevelError {
        if (this.TModeReg == null) {
            return;
        }
        BigInteger tModeValue = BigInteger.ZERO;
        if (contextRegisterValue != null) {
            tModeValue = contextRegisterValue.getRegisterValue(this.TModeReg).getUnsignedValueIgnoreMask();
        }
        if (!BigInteger.ZERO.equals(tModeValue)) {
            tModeValue = BigInteger.ONE;
        }
        this.emu.getMemoryState().setValue(this.TBreg, tModeValue);
    }

    class SetISAModeOpBehavior
    implements OpBehaviorOther {
        SetISAModeOpBehavior() {
        }

        public void evaluate(Emulate emu, Varnode out, Varnode[] inputs) {
            Address currentAddress = emu.getExecuteAddress();
            long tbValue = emu.getMemoryState().getValue(ARMEmulateInstructionStateModifier.this.TBreg);
            if (tbValue == 1L) {
                emu.setContextRegisterValue(ARMEmulateInstructionStateModifier.this.tMode);
                if ((currentAddress.getOffset() & 1L) == 1L) {
                    emu.setExecuteAddress(currentAddress.previous());
                }
            } else if (tbValue == 0L) {
                if ((currentAddress.getOffset() & 1L) == 1L) {
                    throw new LowlevelError("Flow to odd address occurred without setting TB register (Thumb mode)");
                }
                emu.setContextRegisterValue(ARMEmulateInstructionStateModifier.this.aMode);
            }
        }
    }
}

