/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.opensearch.OpenSearchParseException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.model.MLUpdateModelAction;
import org.opensearch.ml.common.transport.model.MLUpdateModelInput;
import org.opensearch.ml.common.transport.model.MLUpdateModelRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestRequestFilter;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestMLUpdateModelAction
extends BaseRestHandler
implements RestRequestFilter {
    private static final String ML_UPDATE_MODEL_ACTION = "ml_update_model_action";
    private MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLUpdateModelAction(MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_UPDATE_MODEL_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.PUT, String.format(Locale.ROOT, "%s/models/{%s}", "/_plugins/_ml", "model_id")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLUpdateModelRequest updateModelRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLUpdateModelAction.INSTANCE, (ActionRequest)updateModelRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private MLUpdateModelRequest getRequest(RestRequest request) throws IOException {
        if (!request.hasContent()) {
            throw new OpenSearchParseException("Update model request has empty body", new Object[0]);
        }
        String modelId = RestActionUtils.getParameterId(request, "model_id");
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        try {
            MLUpdateModelInput input = MLUpdateModelInput.parse((XContentParser)parser);
            if (input.getConnectorId() != null && input.getConnector() != null) {
                throw new OpenSearchStatusException("Model cannot have both stand-alone connector and internal connector. Please check your update input body.", RestStatus.BAD_REQUEST, new Object[0]);
            }
            input.setModelId(modelId);
            input.setVersion(null);
            input.setUpdatedConnector(null);
            input.setTenantId(tenantId);
            return new MLUpdateModelRequest(input);
        }
        catch (IllegalStateException e) {
            throw new OpenSearchParseException(e.getMessage(), new Object[0]);
        }
    }

    public Set<String> getFilteredFields() {
        return Set.of("connector.credential", "*.Authorization");
    }
}

