/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.checksum;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.checksum.Md5ChecksumAlgorithmFactory;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.checksum.Sha1ChecksumAlgorithmFactory;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.checksum.Sha256ChecksumAlgorithmFactory;
import org.jetbrains.kotlin.org.eclipse.aether.internal.impl.checksum.Sha512ChecksumAlgorithmFactory;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactorySelector;

@Singleton
@Named
public class DefaultChecksumAlgorithmFactorySelector
implements ChecksumAlgorithmFactorySelector {
    private final Map<String, ChecksumAlgorithmFactory> factories = new HashMap<String, ChecksumAlgorithmFactory>();

    @Deprecated
    public DefaultChecksumAlgorithmFactorySelector() {
        this.factories.put("SHA-512", new Sha512ChecksumAlgorithmFactory());
        this.factories.put("SHA-256", new Sha256ChecksumAlgorithmFactory());
        this.factories.put("SHA-1", new Sha1ChecksumAlgorithmFactory());
        this.factories.put("MD5", new Md5ChecksumAlgorithmFactory());
    }

    public ChecksumAlgorithmFactory select(String algorithmName) {
        Objects.requireNonNull(algorithmName, "algorithmMame must not be null");
        ChecksumAlgorithmFactory factory = this.factories.get(algorithmName);
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Unsupported checksum algorithm %s, supported ones are %s", algorithmName, this.getChecksumAlgorithmFactories().stream().map(ChecksumAlgorithmFactory::getName).collect(Collectors.toList())));
        }
        return factory;
    }

    @Override
    public List<ChecksumAlgorithmFactory> selectList(Collection<String> algorithmNames) {
        return algorithmNames.stream().map(this::select).collect(Collectors.toList());
    }

    public Collection<ChecksumAlgorithmFactory> getChecksumAlgorithmFactories() {
        return Collections.unmodifiableCollection(this.factories.values());
    }

    @Override
    public boolean isChecksumExtension(String extension) {
        Objects.requireNonNull(extension);
        if (extension.contains(".")) {
            return this.factories.values().stream().anyMatch(a -> extension.endsWith("." + a.getFileExtension()));
        }
        return this.factories.values().stream().anyMatch(a -> extension.equals(a.getFileExtension()));
    }
}

