/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generated;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ShareGroupCurrentMemberAssignmentValue
implements ApiMessage {
    int memberEpoch;
    int previousMemberEpoch;
    byte state;
    List<TopicPartitions> assignedPartitions;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("member_epoch", (Type)Type.INT32, "The current member epoch that is expected from the member in the heartbeat request."), new Field("previous_member_epoch", (Type)Type.INT32, "If the last epoch bump is lost before reaching the member, the member will retry with the previous epoch."), new Field("state", (Type)Type.INT8, "The member state. See MemberState for the possible values."), new Field("assigned_partitions", (Type)new CompactArrayOf((Type)TopicPartitions.SCHEMA_0), "The partitions assigned to (or owned by) this member."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public ShareGroupCurrentMemberAssignmentValue(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public ShareGroupCurrentMemberAssignmentValue() {
        this.memberEpoch = 0;
        this.previousMemberEpoch = 0;
        this.state = 0;
        this.assignedPartitions = new ArrayList<TopicPartitions>(0);
    }

    public short apiKey() {
        return 14;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public final void read(Readable _readable, short _version) {
        this.memberEpoch = _readable.readInt();
        this.previousMemberEpoch = _readable.readInt();
        this.state = _readable.readByte();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field assignedPartitions was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<TopicPartitions> newCollection = new ArrayList<TopicPartitions>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new TopicPartitions(_readable, _version));
        }
        this.assignedPartitions = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.memberEpoch);
        _writable.writeInt(this.previousMemberEpoch);
        _writable.writeByte(this.state);
        _writable.writeUnsignedVarint(this.assignedPartitions.size() + 1);
        for (TopicPartitions assignedPartitionsElement : this.assignedPartitions) {
            assignedPartitionsElement.write(_writable, _cache, _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(4);
        _size.addBytes(1);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.assignedPartitions.size() + 1)));
        for (TopicPartitions assignedPartitionsElement : this.assignedPartitions) {
            assignedPartitionsElement.addSize(_size, _cache, _version);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShareGroupCurrentMemberAssignmentValue)) {
            return false;
        }
        ShareGroupCurrentMemberAssignmentValue other = (ShareGroupCurrentMemberAssignmentValue)obj;
        if (this.memberEpoch != other.memberEpoch) {
            return false;
        }
        if (this.previousMemberEpoch != other.previousMemberEpoch) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        if (this.assignedPartitions == null ? other.assignedPartitions != null : !this.assignedPartitions.equals(other.assignedPartitions)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.memberEpoch;
        hashCode = 31 * hashCode + this.previousMemberEpoch;
        hashCode = 31 * hashCode + this.state;
        hashCode = 31 * hashCode + (this.assignedPartitions == null ? 0 : this.assignedPartitions.hashCode());
        return hashCode;
    }

    public ShareGroupCurrentMemberAssignmentValue duplicate() {
        ShareGroupCurrentMemberAssignmentValue _duplicate = new ShareGroupCurrentMemberAssignmentValue();
        _duplicate.memberEpoch = this.memberEpoch;
        _duplicate.previousMemberEpoch = this.previousMemberEpoch;
        _duplicate.state = this.state;
        ArrayList<TopicPartitions> newAssignedPartitions = new ArrayList<TopicPartitions>(this.assignedPartitions.size());
        for (TopicPartitions _element : this.assignedPartitions) {
            newAssignedPartitions.add(_element.duplicate());
        }
        _duplicate.assignedPartitions = newAssignedPartitions;
        return _duplicate;
    }

    public String toString() {
        return "ShareGroupCurrentMemberAssignmentValue(memberEpoch=" + this.memberEpoch + ", previousMemberEpoch=" + this.previousMemberEpoch + ", state=" + this.state + ", assignedPartitions=" + MessageUtil.deepToString(this.assignedPartitions.iterator()) + ")";
    }

    public int memberEpoch() {
        return this.memberEpoch;
    }

    public int previousMemberEpoch() {
        return this.previousMemberEpoch;
    }

    public byte state() {
        return this.state;
    }

    public List<TopicPartitions> assignedPartitions() {
        return this.assignedPartitions;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ShareGroupCurrentMemberAssignmentValue setMemberEpoch(int v) {
        this.memberEpoch = v;
        return this;
    }

    public ShareGroupCurrentMemberAssignmentValue setPreviousMemberEpoch(int v) {
        this.previousMemberEpoch = v;
        return this;
    }

    public ShareGroupCurrentMemberAssignmentValue setState(byte v) {
        this.state = v;
        return this;
    }

    public ShareGroupCurrentMemberAssignmentValue setAssignedPartitions(List<TopicPartitions> v) {
        this.assignedPartitions = v;
        return this;
    }

    public static class TopicPartitions
    implements Message {
        Uuid topicId;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topic_id", (Type)Type.UUID, "The topic Id."), new Field("partitions", (Type)new CompactArrayOf((Type)Type.INT32), "The partition Ids."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public TopicPartitions(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public TopicPartitions() {
            this.topicId = Uuid.ZERO_UUID;
            this.partitions = new ArrayList<Integer>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public final void read(Readable _readable, short _version) {
            this.topicId = _readable.readUuid();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _writable.writeUuid(this.topicId);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            for (Integer partitionsElement : this.partitions) {
                _writable.writeInt(partitionsElement.intValue());
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            _size.addBytes(16);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.partitions.size() + 1)));
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicPartitions)) {
                return false;
            }
            TopicPartitions other = (TopicPartitions)obj;
            if (!this.topicId.equals((Object)other.topicId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public TopicPartitions duplicate() {
            TopicPartitions _duplicate = new TopicPartitions();
            _duplicate.topicId = this.topicId;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "TopicPartitions(topicId=" + this.topicId.toString() + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicPartitions setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public TopicPartitions setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }
    }
}

