/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import docking.ActionContext;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceLocationPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceSelectionPluginEvent;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.utils.ProgramURLUtils;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.FileImporterService;
import ghidra.app.services.ProgramManager;
import ghidra.debug.api.modules.DebuggerMissingModuleActionContext;
import ghidra.debug.api.modules.DebuggerOpenProgramActionContext;
import ghidra.debug.api.modules.DebuggerStaticMappingChangeListener;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.model.DomainFile;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoConfigStateField;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressCollectors;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceSpan;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceModuleManager;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.modules.TraceStaticMapping;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;

@PluginInfo(shortDescription="Debugger static synchronization", description="Synchronizes the static and dynamic listings (and other components) where the module map is known", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={ProgramOpenedPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramLocationPluginEvent.class, ProgramSelectionPluginEvent.class, TraceActivatedPluginEvent.class, TraceLocationPluginEvent.class, TraceSelectionPluginEvent.class}, eventsProduced={ProgramLocationPluginEvent.class, ProgramSelectionPluginEvent.class, TraceLocationPluginEvent.class, TraceSelectionPluginEvent.class}, servicesRequired={DebuggerStaticMappingService.class})
public class DynamicStaticSynchronizationPlugin
extends Plugin {
    protected static final AutoConfigState.ClassHandler<DynamicStaticSynchronizationPlugin> CONFIG_STATE_HANDLER = AutoConfigState.wireHandler(DynamicStaticSynchronizationPlugin.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected ToggleDockingAction actionSyncLocations;
    protected ToggleDockingAction actionSyncSelections;
    protected DockingAction actionTransferSelectionDynamicToStatic;
    protected DockingAction actionTransferSelectionStaticToDynamic;
    protected DockingAction actionOpenProgram;
    @AutoConfigStateField
    private boolean syncLocations = true;
    @AutoConfigStateField
    private boolean syncSelections = true;
    private DebuggerStaticMappingService mappingService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerConsoleService consoleService;
    @AutoServiceConsumed
    private ProgramManager programManager;
    @AutoServiceConsumed
    private FileImporterService importerService;
    private final AutoService.Wiring autoServiceWiring;
    protected final ForStaticSyncMappingChangeListener mappingChangeListener = new ForStaticSyncMappingChangeListener();
    private StablePoint stablePoint;
    private DebuggerCoordinates currentDynamic = DebuggerCoordinates.NOWHERE;
    private ProgramLocation currentDynamicLocation;
    private ProgramSelection currentDynamicSelection;
    private Program currentStatic;
    private ProgramLocation currentStaticLocation;
    private ProgramSelection currentStaticSelection;

    private boolean hasDynamicSelection(ProgramLocationActionContext ctx) {
        return this.currentDynamicSelection != null && !this.currentDynamicSelection.isEmpty();
    }

    private boolean hasStaticSelection(ProgramLocationActionContext ctx) {
        return this.currentStaticSelection != null && !this.currentStaticSelection.isEmpty();
    }

    public DynamicStaticSynchronizationPlugin(PluginTool tool) {
        super(tool);
        this.autoServiceWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
        this.createActions();
    }

    protected void dispose() {
        super.dispose();
        if (this.consoleService != null && this.actionOpenProgram != null) {
            this.consoleService.removeResolutionAction((DockingActionIf)this.actionOpenProgram);
        }
    }

    @AutoServiceConsumed
    private void setMappingService(DebuggerStaticMappingService mappingService) {
        if (this.mappingService != null) {
            this.mappingService.removeChangeListener((DebuggerStaticMappingChangeListener)this.mappingChangeListener);
        }
        this.mappingService = mappingService;
        if (this.mappingService != null) {
            this.mappingService.addChangeListener((DebuggerStaticMappingChangeListener)this.mappingChangeListener);
            if (this.isSyncLocations()) {
                this.doSendLocationFromStable();
            }
            if (this.isSyncSelections()) {
                this.doSendSelectionFromStable();
            }
        }
    }

    @AutoServiceConsumed
    private void setConsoleService(DebuggerConsoleService consoleService) {
        if (consoleService != null && this.actionOpenProgram != null) {
            consoleService.addResolutionAction((DockingActionIf)this.actionOpenProgram);
        }
    }

    protected void createActions() {
        this.actionSyncLocations = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)SyncLocationsAction.builder(this).enabled(true)).selected(true).onAction(ctx -> this.doSetSyncLocations(this.actionSyncLocations.isSelected()))).buildAndInstall((Tool)this.tool);
        this.actionSyncSelections = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)SyncSelectionsAction.builder(this).enabled(true)).selected(true).onAction(ctx -> this.doSetSyncSelections(this.actionSyncSelections.isSelected()))).buildAndInstall((Tool)this.tool);
        this.actionTransferSelectionDynamicToStatic = (DockingAction)TransferSelectionDynamicToStaticAction.builder(this).withContext(ProgramLocationActionContext.class).enabledWhen(this::hasDynamicSelection).onAction(this::activatedTransferSelectionDynamicToStatic).buildAndInstall((Tool)this.tool);
        this.actionTransferSelectionStaticToDynamic = (DockingAction)TransferSelectionStaticToDynamicAction.builder(this).withContext(ProgramLocationActionContext.class).enabledWhen(this::hasStaticSelection).onAction(this::activatedTransferSelectionStaticToDynamic).buildAndInstall((Tool)this.tool);
        this.actionOpenProgram = (DockingAction)OpenProgramAction.builder(this).withContext(DebuggerOpenProgramActionContext.class).onAction(this::activatedOpenProgram).build();
    }

    protected void doSetSyncLocations(boolean sync) {
        this.syncLocations = sync;
        if (this.isSyncLocations()) {
            this.doSendLocationFromStable();
        }
    }

    protected void doSetSyncSelections(boolean sync) {
        this.syncSelections = sync;
        if (this.isSyncSelections()) {
            this.doSendSelectionFromStable();
        }
    }

    protected void displayMapError(String from, String to) {
        this.tool.setStatusInfo("No selected addresses in " + from + " are mappable to " + to + ". Check your module list and static mappings.", true);
    }

    private void activatedTransferSelectionDynamicToStatic(ActionContext ctx) {
        this.stablePoint = StablePoint.DYNAMIC;
        ProgramSelection result = this.doSendSelectionDynamicToStatic();
        if (result != null && result.isEmpty()) {
            this.displayMapError("the dynamic view", "the static listing");
        }
    }

    private void activatedTransferSelectionStaticToDynamic(ActionContext ctx) {
        this.stablePoint = StablePoint.STATIC;
        ProgramSelection result = this.doSendSelectionStaticToDynamic();
        if (result != null && result.isEmpty()) {
            this.displayMapError("the static listing", "the dynamic view");
        }
    }

    private void activatedOpenProgram(DebuggerOpenProgramActionContext context) {
        this.programManager.openProgram(context.getDomainFile(), -1, 1);
    }

    private void doSendLocationFromStable() {
        StablePoint stablePoint = this.stablePoint;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"STATIC", "DYNAMIC"}, (StablePoint)stablePoint, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case -1: {
                break;
            }
            case 0: {
                this.doSendLocationStaticToDynamic();
                break;
            }
            case 1: {
                this.doSendLocationDynamicToStatic();
            }
        }
    }

    private void doSendSelectionFromStable() {
        StablePoint stablePoint = this.stablePoint;
        int n = 0;
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"STATIC", "DYNAMIC"}, (StablePoint)stablePoint, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case -1: {
                break;
            }
            case 0: {
                this.doSendSelectionStaticToDynamic();
                break;
            }
            case 1: {
                this.doSendSelectionDynamicToStatic();
            }
        }
    }

    private void doSendLocationStaticToDynamic() {
        if (this.mappingService == null || this.currentStaticLocation == null) {
            return;
        }
        TraceProgramView view = this.currentDynamic.getView();
        if (view == null) {
            return;
        }
        ProgramLocation dynamicLoc = this.mappingService.getDynamicLocationFromStatic(view, this.currentStaticLocation);
        if (dynamicLoc == null) {
            return;
        }
        this.currentDynamicLocation = dynamicLoc;
        this.firePluginEvent((PluginEvent)new TraceLocationPluginEvent(this.getName(), dynamicLoc));
    }

    private void doSendLocationDynamicToStatic() {
        if (this.mappingService == null || this.currentDynamicLocation == null) {
            return;
        }
        this.doCheckCurrentModuleMissing();
        TraceProgramView view = this.currentDynamic.getView();
        if (view == null) {
            return;
        }
        ProgramLocation staticLoc = this.mappingService.getStaticLocationFromDynamic(this.currentDynamicLocation);
        if (staticLoc == null) {
            return;
        }
        if (this.currentStatic != staticLoc.getProgram()) {
            this.currentStatic = staticLoc.getProgram();
            this.firePluginEvent((PluginEvent)new ProgramActivatedPluginEvent(this.getName(), staticLoc.getProgram()));
        }
        this.currentStaticLocation = staticLoc;
        this.firePluginEvent((PluginEvent)new ProgramLocationPluginEvent(this.getName(), staticLoc, staticLoc.getProgram()));
    }

    private ProgramSelection doSendSelectionStaticToDynamic() {
        ProgramSelection dynamicSel;
        if (this.mappingService == null || this.currentStatic == null || this.currentStaticSelection == null) {
            return null;
        }
        TraceProgramView view = this.currentDynamic.getView();
        if (view == null) {
            return null;
        }
        AddressSet dynamicAddrs = (AddressSet)this.mappingService.getOpenMappedViews(this.currentStatic, (AddressSetView)this.currentStaticSelection).entrySet().stream().filter(e -> ((TraceSpan)e.getKey()).getTrace() == view.getTrace()).filter(e -> ((TraceSpan)e.getKey()).getSpan().contains(this.currentDynamic.getSnap())).flatMap(e -> ((Collection)e.getValue()).stream()).map(r -> r.getDestinationAddressRange()).collect(AddressCollectors.toAddressSet());
        this.currentDynamicSelection = dynamicSel = new ProgramSelection((AddressSetView)dynamicAddrs);
        this.firePluginEvent((PluginEvent)new TraceSelectionPluginEvent(this.getName(), dynamicSel, view));
        return dynamicSel;
    }

    private ProgramSelection doSendSelectionDynamicToStatic() {
        ProgramSelection staticSel;
        if (this.mappingService == null || this.currentStatic == null || this.currentDynamicSelection == null) {
            return null;
        }
        TraceProgramView view = this.currentDynamic.getView();
        if (view == null) {
            return null;
        }
        Collection ranges = (Collection)this.mappingService.getOpenMappedViews(view.getTrace(), (AddressSetView)this.currentDynamicSelection, this.currentDynamic.getSnap()).get(this.currentStatic);
        AddressSet staticAddrs = ranges == null ? null : (AddressSet)ranges.stream().map(r -> r.getDestinationAddressRange()).collect(AddressCollectors.toAddressSet());
        this.currentStaticSelection = staticSel = new ProgramSelection(staticAddrs);
        this.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent(this.getName(), staticSel, this.currentStatic));
        return staticSel;
    }

    public void processEvent(PluginEvent event) {
        PluginEvent pluginEvent = event;
        Objects.requireNonNull(pluginEvent);
        PluginEvent pluginEvent2 = pluginEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProgramOpenedPluginEvent.class, ProgramActivatedPluginEvent.class, ProgramLocationPluginEvent.class, ProgramSelectionPluginEvent.class, TraceActivatedPluginEvent.class, TraceLocationPluginEvent.class, TraceSelectionPluginEvent.class}, (Object)pluginEvent2, n)) {
            case 0: {
                ProgramOpenedPluginEvent ev = (ProgramOpenedPluginEvent)pluginEvent2;
                this.programOpened(ev);
                break;
            }
            case 1: {
                ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)pluginEvent2;
                this.programActivated(ev);
                break;
            }
            case 2: {
                ProgramLocationPluginEvent ev = (ProgramLocationPluginEvent)pluginEvent2;
                this.staticLocationChanged(ev);
                break;
            }
            case 3: {
                ProgramSelectionPluginEvent ev = (ProgramSelectionPluginEvent)pluginEvent2;
                this.staticSelectionChanged(ev);
                break;
            }
            case 4: {
                TraceActivatedPluginEvent ev = (TraceActivatedPluginEvent)pluginEvent2;
                this.coordinatesActivated(ev);
                break;
            }
            case 5: {
                TraceLocationPluginEvent ev = (TraceLocationPluginEvent)pluginEvent2;
                this.dynamicLocationChanged(ev);
                break;
            }
            case 6: {
                TraceSelectionPluginEvent ev = (TraceSelectionPluginEvent)pluginEvent2;
                this.dynamicSelectionChanged(ev);
                break;
            }
        }
    }

    private void programOpened(ProgramOpenedPluginEvent event) {
        DomainFile df = event.getProgram().getDomainFile();
        DebuggerOpenProgramActionContext ctx = new DebuggerOpenProgramActionContext(df);
        if (this.consoleService != null) {
            this.consoleService.removeFromLog((ActionContext)ctx);
        }
    }

    private void programActivated(ProgramActivatedPluginEvent event) {
        this.currentStatic = event.getActiveProgram();
    }

    private void staticLocationChanged(ProgramLocationPluginEvent event) {
        this.currentStaticLocation = event.getLocation();
        this.stablePoint = StablePoint.STATIC;
        if (this.isSyncLocations()) {
            this.doSendLocationStaticToDynamic();
        }
    }

    private void staticSelectionChanged(ProgramSelectionPluginEvent event) {
        this.currentStaticSelection = event.getSelection();
        this.stablePoint = StablePoint.STATIC;
        if (this.isSyncSelections()) {
            this.doSendSelectionStaticToDynamic();
        }
    }

    private void coordinatesActivated(TraceActivatedPluginEvent event) {
        this.currentDynamic = event.getActiveCoordinates();
    }

    private void dynamicLocationChanged(TraceLocationPluginEvent event) {
        this.currentDynamicLocation = event.getLocation();
        this.stablePoint = StablePoint.DYNAMIC;
        if (this.isSyncLocations()) {
            this.doSendLocationDynamicToStatic();
        }
    }

    private void dynamicSelectionChanged(TraceSelectionPluginEvent event) {
        this.currentDynamicSelection = event.getSelection();
        this.stablePoint = StablePoint.DYNAMIC;
        if (this.isSyncSelections()) {
            this.doSendSelectionDynamicToStatic();
        }
    }

    public void setSyncLocations(boolean sync) {
        this.actionSyncLocations.setSelected(sync);
        this.doSetSyncLocations(sync);
    }

    public boolean isSyncLocations() {
        return this.syncLocations;
    }

    public void setSyncSelections(boolean sync) {
        this.actionSyncSelections.setSelected(sync);
        this.doSetSyncSelections(sync);
    }

    public boolean isSyncSelections() {
        return this.syncSelections;
    }

    public void readConfigState(SaveState saveState) {
        CONFIG_STATE_HANDLER.readConfigState((Object)this, saveState);
        this.actionSyncLocations.setSelected(this.syncLocations);
        this.actionSyncSelections.setSelected(this.syncSelections);
    }

    protected void doTryOpenProgram(final DomainFile df, int version, final int state) {
        final DebuggerOpenProgramActionContext ctx = new DebuggerOpenProgramActionContext(df);
        if (this.consoleService != null && this.consoleService.logContains((ActionContext)ctx)) {
            return;
        }
        if (df.canRecover()) {
            if (this.consoleService != null) {
                this.consoleService.log(DebuggerResources.ICON_MODULES, "<html>Program <b>" + HTMLUtilities.escapeHTML((String)df.getPathname()) + "</b> has recovery data. It must be opened manually.</html>", (ActionContext)ctx);
            }
            return;
        }
        new TaskLauncher(new Task("Open " + String.valueOf(df), true, false, false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(TaskMonitor monitor) throws CancelledException {
                Program program = null;
                try {
                    program = (Program)df.getDomainObject((Object)this, false, false, monitor);
                    DynamicStaticSynchronizationPlugin.this.programManager.openProgram(program, state);
                }
                catch (VersionException e) {
                    if (DynamicStaticSynchronizationPlugin.this.consoleService != null) {
                        DynamicStaticSynchronizationPlugin.this.consoleService.log(DebuggerResources.ICON_MODULES, "<html>Program <b>" + HTMLUtilities.escapeHTML((String)df.getPathname()) + "</b> was imported with a different version of Ghidra. It must be opened manually.</html>", (ActionContext)ctx);
                    }
                    return;
                }
                catch (Exception e) {
                    if (DynamicStaticSynchronizationPlugin.this.consoleService != null) {
                        DynamicStaticSynchronizationPlugin.this.consoleService.log(DebuggerResources.ICON_LOG_ERROR, "<html>Program <b>" + HTMLUtilities.escapeHTML((String)df.getPathname()) + "</b> could not be opened: " + String.valueOf(e) + ". Try opening it manually.</html>", (ActionContext)ctx);
                    }
                    return;
                }
                finally {
                    if (program != null) {
                        program.release((Object)this);
                    }
                }
            }
        }, (Component)this.tool.getToolFrame());
    }

    protected boolean isMapped(AddressRange range) {
        if (range == null) {
            return false;
        }
        return this.mappingService.getStaticLocationFromDynamic(new ProgramLocation((Program)this.currentDynamic.getView(), range.getMinAddress())) != null;
    }

    protected void cleanMissingModuleMessages(Set<Trace> affectedTraces) {
        if (this.consoleService == null) {
            return;
        }
        block0: for (ActionContext ctx : this.consoleService.getActionContexts()) {
            DebuggerMissingModuleActionContext mmCtx;
            TraceModule module;
            if (!(ctx instanceof DebuggerMissingModuleActionContext) || !affectedTraces.contains((module = (mmCtx = (DebuggerMissingModuleActionContext)ctx).getModule()).getTrace())) continue;
            long snap = this.traceManager.getCurrentFor(module.getTrace()).getSnap();
            if (this.isMapped(module.getRange(snap))) {
                this.consoleService.removeFromLog((ActionContext)mmCtx);
                continue;
            }
            for (TraceSection section : module.getSections(snap)) {
                if (!this.isMapped(section.getRange(snap))) continue;
                this.consoleService.removeFromLog((ActionContext)mmCtx);
                continue block0;
            }
        }
    }

    protected void doCheckCurrentModuleMissing() {
        DomainFile df;
        Trace trace = this.currentDynamic.getTrace();
        if (trace == null) {
            return;
        }
        ProgramLocation loc = this.currentDynamicLocation;
        if (loc == null) {
            return;
        }
        AddressSpace space = loc.getAddress().getAddressSpace();
        if (space == null) {
            return;
        }
        if (this.mappingService == null) {
            return;
        }
        ProgramLocation mapped = this.mappingService.getStaticLocationFromDynamic(loc);
        if (mapped != null) {
            return;
        }
        long snap = this.currentDynamic.getSnap();
        Address address = loc.getAddress();
        TraceStaticMapping mapping = trace.getStaticMappingManager().findContaining(address, snap);
        if (mapping != null && (df = ProgramURLUtils.getDomainFileFromOpenProject(this.tool.getProject(), mapping.getStaticProgramURL())) != null) {
            this.doTryOpenProgram(df, -1, 1);
        }
        HashSet<TraceModule> missing = new HashSet<TraceModule>();
        HashSet<DomainFile> toOpen = new HashSet<DomainFile>();
        TraceModuleManager modMan = trace.getModuleManager();
        Collection modules = Stream.concat(modMan.getModulesAt(snap, address).stream().filter(m -> m.getSections(snap).isEmpty()), modMan.getSectionsAt(snap, address).stream().map(s -> s.getModule())).collect(Collectors.toSet());
        for (TraceModule mod : modules) {
            DomainFile match = this.mappingService.findBestModuleProgram(space, mod, snap);
            if (match == null) {
                missing.add(mod);
                continue;
            }
            toOpen.add(match);
        }
        if (this.programManager != null && !toOpen.isEmpty()) {
            for (DomainFile df2 : toOpen) {
                this.doTryOpenProgram(df2, -1, 2);
            }
        }
        if (this.importerService == null || this.consoleService == null) {
            return;
        }
        for (TraceModule mod : missing) {
            this.consoleService.log(DebuggerResources.ICON_LOG_ERROR, "<html>The module <b><tt>" + HTMLUtilities.escapeHTML((String)mod.getName(snap)) + "</tt></b> was not found in the project</html>", (ActionContext)new DebuggerMissingModuleActionContext(mod));
        }
    }

    protected class ForStaticSyncMappingChangeListener
    implements DebuggerStaticMappingChangeListener {
        protected ForStaticSyncMappingChangeListener() {
        }

        public void mappingsChanged(Set<Trace> affectedTraces, Set<Program> affectedPrograms) {
            Swing.runIfSwingOrRunLater(() -> {
                if (DynamicStaticSynchronizationPlugin.this.currentDynamic.getView() == null) {
                    return;
                }
                if (!affectedTraces.contains(DynamicStaticSynchronizationPlugin.this.currentDynamic.getTrace())) {
                    return;
                }
                DynamicStaticSynchronizationPlugin.this.cleanMissingModuleMessages(affectedTraces);
                if (DynamicStaticSynchronizationPlugin.this.isSyncLocations()) {
                    DynamicStaticSynchronizationPlugin.this.doSendLocationFromStable();
                }
                if (DynamicStaticSynchronizationPlugin.this.isSyncSelections()) {
                    DynamicStaticSynchronizationPlugin.this.doSendSelectionFromStable();
                }
            });
        }
    }

    static interface SyncLocationsAction {
        public static final String NAME = "Synchronize Static and Dynamic Locations";
        public static final String DESCRIPTION = "Automatically synchronize the static and dynamic listings' cursors";
        public static final String HELP_ANCHOR = "sync_locations";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{"Debugger", "Synchronization", NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface SyncSelectionsAction {
        public static final String NAME = "Synchronize Static and Dynamic Selections";
        public static final String DESCRIPTION = "Automatically synchronize the static and dynamic listings' selections";
        public static final String HELP_ANCHOR = "sync_selections";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{"Debugger", "Synchronization", NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface TransferSelectionDynamicToStaticAction {
        public static final String NAME = "Transfer Dynamic Selection to Static";
        public static final String DESCRIPTION = "Change the static selection to match the dynamic selection";
        public static final String HELP_ANCHOR = "transfer_selection_dynamic_to_static";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{"Debugger", "Synchronization", NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface TransferSelectionStaticToDynamicAction {
        public static final String NAME = "Transfer Static Selection to Dynamic";
        public static final String DESCRIPTION = "Change the dynamic seleciton to mathc the static selection";
        public static final String HELP_ANCHOR = "transfer_selection_static_to_dynamic";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuPath(new String[]{"Debugger", "Synchronization", NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface OpenProgramAction {
        public static final String NAME = "Open Program";
        public static final Icon ICON = DebuggerResources.ICON_PROGRAM;
        public static final String DESCRIPTION = "Open the program";
        public static final String HELP_ANCHOR = "open_program";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).toolBarIcon(ICON)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static enum StablePoint {
        STATIC,
        DYNAMIC;

    }
}

