/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database;

import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.data.LinkHandler;
import ghidra.framework.data.URLLinkObject;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.FileSystem;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceContentHandler;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import javax.swing.Icon;

public class DBTraceLinkContentHandler
extends LinkHandler<DBTrace> {
    public static final String TRACE_LINK_CONTENT_TYPE = "TraceLink";

    public long createFile(FileSystem fs, FileSystem userfs, String path, String name, DomainObject obj, TaskMonitor monitor) throws IOException, InvalidNameException, CancelledException {
        if (!(obj instanceof URLLinkObject)) {
            throw new IOException("Unsupported domain object: " + obj.getClass().getName());
        }
        return this.createFile((DomainObjectAdapterDB)((URLLinkObject)obj), TRACE_LINK_CONTENT_TYPE, fs, path, name, monitor);
    }

    public String getContentType() {
        return TRACE_LINK_CONTENT_TYPE;
    }

    public String getContentTypeDisplayString() {
        return TRACE_LINK_CONTENT_TYPE;
    }

    public Class<DBTrace> getDomainObjectClass() {
        return DBTraceContentHandler.TRACE_DOMAIN_OBJECT_CLASS;
    }

    public Icon getIcon() {
        return DBTraceContentHandler.TRACE_ICON;
    }

    public String getDefaultToolName() {
        return "Debugger";
    }
}

