/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import generic.expressions.ExpressionException;
import generic.expressions.ExpressionOperator;
import generic.expressions.ExpressionValue;
import generic.expressions.LongExpressionValue;
import ghidra.program.model.address.Address;

public class AddressExpressionValue
implements ExpressionValue {
    private Address value;

    public AddressExpressionValue(Address address) {
        this.value = address;
    }

    public ExpressionValue applyUnaryOperator(ExpressionOperator operator) throws ExpressionException {
        long offset = this.value.getOffset();
        switch (operator) {
            case BITWISE_NOT: {
                return this.addressExpressionOf(offset ^ 0xFFFFFFFFFFFFFFFFL);
            }
            case UNARY_MINUS: {
                return this.addressExpressionOf(-offset);
            }
            case UNARY_PLUS: {
                return this;
            }
        }
        throw new ExpressionException("Unary Operator " + String.valueOf(operator) + " not supported by Long values!");
    }

    private AddressExpressionValue addressExpressionOf(long offset) {
        Address address = this.value.getNewAddress(offset);
        return new AddressExpressionValue(this.addressOf(offset));
    }

    private AddressExpressionValue addressExpressionOf(Address address) {
        return new AddressExpressionValue(address);
    }

    private Address addressOf(long offset) {
        return this.value.getNewAddress(offset);
    }

    public ExpressionValue applyBinaryOperator(ExpressionOperator operator, ExpressionValue operand) throws ExpressionException {
        if (operand instanceof LongExpressionValue) {
            LongExpressionValue longOperand = (LongExpressionValue)operand;
            return this.applyBinaryOperator(operator, longOperand);
        }
        if (operand instanceof AddressExpressionValue) {
            AddressExpressionValue addressOperand = (AddressExpressionValue)operand;
            return this.applyBinaryOperator(operator, addressOperand);
        }
        throw new ExpressionException("Unsupported operand type for Long: " + String.valueOf(this.value));
    }

    private ExpressionValue applyBinaryOperator(ExpressionOperator operator, LongExpressionValue expressionValue) throws ExpressionException {
        long otherValue = expressionValue.getLongValue();
        long offset = this.value.getOffset();
        int compareResult = Long.compareUnsigned(offset, otherValue);
        switch (operator) {
            case BITWISE_AND: {
                return this.addressExpressionOf(offset & otherValue);
            }
            case BITWISE_OR: {
                return this.addressExpressionOf(offset | otherValue);
            }
            case BITWISE_XOR: {
                return this.addressExpressionOf(offset ^ otherValue);
            }
            case DIVIDE: {
                return this.addressExpressionOf(offset / otherValue);
            }
            case SUBTRACT: {
                return this.addressExpressionOf(this.value.subtract(otherValue));
            }
            case ADD: {
                return this.addressExpressionOf(this.value.add(otherValue));
            }
            case MULTIPLY: {
                return this.addressExpressionOf(offset * otherValue);
            }
            case SHIFT_LEFT: {
                return this.addressExpressionOf(offset << (int)otherValue);
            }
            case SHIFT_RIGHT: {
                return this.addressExpressionOf(offset >> (int)otherValue);
            }
            case EQUALS: {
                return this.booleanExpression(compareResult == 0);
            }
            case GREATER_THAN: {
                return this.booleanExpression(compareResult > 0);
            }
            case LESS_THAN: {
                return this.booleanExpression(compareResult < 0);
            }
            case GREATER_THAN_OR_EQUAL: {
                return this.booleanExpression(compareResult >= 0);
            }
            case LESS_THAN_OR_EQUAL: {
                return this.booleanExpression(compareResult <= 0);
            }
        }
        throw new ExpressionException("Binary Operator \"" + String.valueOf(operator) + "\" with Long operands not supported by Address values!");
    }

    private ExpressionValue booleanExpression(boolean b) {
        return new LongExpressionValue(b ? 1L : 0L);
    }

    private ExpressionValue applyBinaryOperator(ExpressionOperator operator, AddressExpressionValue expressionValue) throws ExpressionException {
        Address otherValue = expressionValue.getAddress();
        long otherValueOffset = otherValue.getOffset();
        long offset = this.value.getOffset();
        int compareResult = this.value.compareTo(otherValue);
        switch (operator) {
            case BITWISE_AND: {
                return new LongExpressionValue(offset & otherValueOffset);
            }
            case BITWISE_OR: {
                return new LongExpressionValue(offset | otherValueOffset);
            }
            case BITWISE_XOR: {
                return new LongExpressionValue(offset ^ otherValueOffset);
            }
            case SUBTRACT: {
                return new LongExpressionValue(this.value.subtract(otherValue));
            }
            case ADD: {
                return new LongExpressionValue(offset + otherValueOffset);
            }
            case EQUALS: {
                return this.booleanExpression(compareResult == 0);
            }
            case GREATER_THAN: {
                return this.booleanExpression(compareResult > 0);
            }
            case LESS_THAN: {
                return this.booleanExpression(compareResult < 0);
            }
            case GREATER_THAN_OR_EQUAL: {
                return this.booleanExpression(compareResult >= 0);
            }
            case LESS_THAN_OR_EQUAL: {
                return this.booleanExpression(compareResult <= 0);
            }
        }
        throw new ExpressionException("Binary Operator \"" + String.valueOf(operator) + "\" with Long operands not supported by Address values!");
    }

    public Address getAddress() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }
}

