/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.datastruct.SoftCacheMap;

public abstract class DynamicDataType
extends BuiltIn
implements Dynamic {
    private SoftCacheMap<Address, DataTypeComponent[]> map = new SoftCacheMap(100);

    protected DynamicDataType(String name) {
        this(CategoryPath.ROOT, name, null);
    }

    protected DynamicDataType(String name, DataTypeManager dtm) {
        this(CategoryPath.ROOT, name, dtm);
    }

    protected DynamicDataType(CategoryPath path, String name) {
        this(path, name, null);
    }

    protected DynamicDataType(CategoryPath path, String name, DataTypeManager dtm) {
        super(path, name, dtm);
    }

    @Override
    public final boolean canSpecifyLength() {
        return false;
    }

    public final int getNumComponents(MemBuffer buf) {
        DataTypeComponent[] comps = this.getComps(buf);
        if (comps == null || comps.length == 0) {
            return -1;
        }
        return comps.length;
    }

    protected DataTypeComponent[] getComps(MemBuffer buf) {
        Address addr = buf.getAddress();
        DataTypeComponent[] comps = (DataTypeComponent[])this.map.get((Object)addr);
        if (comps == null) {
            comps = this.getAllComponents(buf);
            if (comps == null) {
                return null;
            }
            this.map.put((Object)addr, (Object)comps);
        }
        return comps;
    }

    public final DataTypeComponent getComponent(int ordinal, MemBuffer buf) {
        DataTypeComponent[] comps = this.getComps(buf);
        if (comps != null) {
            return comps[ordinal];
        }
        return null;
    }

    public final DataTypeComponent[] getComponents(MemBuffer buf) {
        return this.getComps(buf);
    }

    public final DataTypeComponent getComponentAt(int offset, MemBuffer buf) {
        DataTypeComponent[] comps = this.getComps(buf);
        if (comps == null) {
            return null;
        }
        for (DataTypeComponent comp : comps) {
            if (comp == null || offset < comp.getOffset() || offset > comp.getEndOffset()) continue;
            return comp;
        }
        return null;
    }

    protected abstract DataTypeComponent[] getAllComponents(MemBuffer var1);

    @Override
    public final int getLength(MemBuffer buf, int maxLength) {
        DataTypeComponent[] comps = this.getComps(buf);
        if (comps == null || comps.length < 1) {
            return -1;
        }
        DataTypeComponent last = comps[comps.length - 1];
        int lastComponentLength = last.getLength();
        return last.getOffset() + lastComponentLength;
    }

    @Override
    public int getLength() {
        return -1;
    }

    public void invalidateCache() {
        this.map.clear();
    }

    @Override
    public DataType getReplacementBaseType() {
        return ByteDataType.dataType;
    }
}

