/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.util.UniversalID;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import utility.application.ApplicationLayout;

public class DataTypeArchiveIdDumper
implements GhidraLaunchable {
    public void launch(GhidraApplicationLayout layout, String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("Usage: DataTypeArchiveDumper <ArchiveFileName> <outputFileName");
            System.exit(0);
        }
        Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)new ApplicationConfiguration());
        File archiveFile = new File(args[0]);
        File outputFile = new File(args[1]);
        FileWriter writer = new FileWriter(outputFile);
        FileDataTypeManager archive = FileDataTypeManager.openFileArchive(archiveFile, false);
        archive.logWarning();
        UniversalID universalID2 = archive.getUniversalID();
        writer.write("FILE_ID: " + Long.toHexString(universalID2.getValue()));
        writer.write("\n");
        Iterator<DataType> it = archive.getAllDataTypes();
        while (it.hasNext()) {
            DataType dt = it.next();
            UniversalID universalID = dt.getUniversalID();
            if (universalID != null) {
                String pathName = dt.getPathName();
                writer.write(Long.toHexString(universalID.getValue()));
                writer.write(" ");
                writer.write(pathName);
                writer.write("\n");
                continue;
            }
            System.out.println("No id for " + dt.getPathName());
        }
        writer.close();
    }
}

