/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.AbstractElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.Xtensa_ElfRelocationType;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;

public class Xtensa_ElfRelocationHandler
extends AbstractElfRelocationHandler<Xtensa_ElfRelocationType, ElfRelocationContext<?>> {
    public static final int EM_XTENSA_OLD = 43975;

    public Xtensa_ElfRelocationHandler() {
        super(Xtensa_ElfRelocationType.class);
    }

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 94 || elf.e_machine() == 43975;
    }

    protected RelocationResult relocate(ElfRelocationContext<?> elfRelocationContext, ElfRelocation relocation, Xtensa_ElfRelocationType type, Address relocationAddress, ElfSymbol elfSymbol, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        int addend = (int)relocation.getAddend();
        int byteLength = -1;
        switch (type) {
            case R_XTENSA_RELATIVE: {
                int newValue = (int)elfRelocationContext.getImageBaseWordAdjustmentOffset() + addend;
                memory.setInt(relocationAddress, newValue);
                byteLength = 4;
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
        }
        if (this.handleUnresolvedSymbol(elfRelocationContext, relocation, relocationAddress)) {
            return RelocationResult.FAILURE;
        }
        int diff_mask = 0;
        boolean neg = false;
        switch (type) {
            case R_XTENSA_32: {
                int newValue = memory.getInt(relocationAddress);
                newValue = (int)((long)newValue + (symbolValue + (long)addend));
                memory.setInt(relocationAddress, newValue);
                byteLength = 4;
                break;
            }
            case R_XTENSA_GLOB_DAT: 
            case R_XTENSA_JMP_SLOT: 
            case R_XTENSA_PLT: {
                int newValue = (int)symbolValue + addend;
                memory.setInt(relocationAddress, newValue);
                byteLength = 4;
                break;
            }
            case R_XTENSA_DIFF8: {
                diff_mask = 127;
                byteLength = 1;
                break;
            }
            case R_XTENSA_DIFF16: {
                diff_mask = Short.MAX_VALUE;
                byteLength = 2;
                break;
            }
            case R_XTENSA_DIFF32: {
                diff_mask = Integer.MAX_VALUE;
                byteLength = 4;
                break;
            }
            case R_XTENSA_TLSDESC_FN: 
            case R_XTENSA_TLSDESC_ARG: 
            case R_XTENSA_TLS_DTPOFF: 
            case R_XTENSA_TLS_TPOFF: 
            case R_XTENSA_TLS_FUNC: 
            case R_XTENSA_TLS_ARG: 
            case R_XTENSA_TLS_CALL: {
                this.markAsWarning(program, relocationAddress, type, symbolName, relocation.getSymbolIndex(), "Thread Local Symbol relocation not supported", elfRelocationContext.getLog());
                break;
            }
            case R_XTENSA_NDIFF8: {
                neg = true;
            }
            case R_XTENSA_PDIFF8: {
                diff_mask = 255;
                byteLength = 1;
                break;
            }
            case R_XTENSA_NDIFF16: {
                neg = true;
            }
            case R_XTENSA_PDIFF16: {
                diff_mask = 65535;
                byteLength = 2;
                break;
            }
            case R_XTENSA_NDIFF32: {
                neg = true;
            }
            case R_XTENSA_PDIFF32: {
                diff_mask = -1;
                byteLength = 4;
                break;
            }
            default: {
                this.markAsUnhandled(program, relocationAddress, type, relocation.getSymbolIndex(), symbolName, elfRelocationContext.getLog());
            }
        }
        if (diff_mask != 0) {
            this.markAsUnhandled(program, relocationAddress, type, relocation.getSymbolIndex(), symbolName, elfRelocationContext.getLog());
            byteLength = -1;
        }
        if (byteLength < 0) {
            return RelocationResult.UNSUPPORTED;
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

