/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.textfield;

import docking.util.GraphicsUtils;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class HexOrDecimalInput
extends JTextField {
    private static final String FONT_ID = "font.input.hint";
    private boolean isHexMode = false;
    private boolean allowsNegative = true;
    private Long currentValue;

    public HexOrDecimalInput() {
        this((Long)null);
    }

    public HexOrDecimalInput(int columns) {
        super(columns);
        this.init(null);
    }

    public HexOrDecimalInput(Long initialValue) {
        this.init(initialValue);
    }

    private void init(Long initialValue) {
        this.currentValue = initialValue;
        this.setDocument(new MyDocument());
        this.updateText();
        this.setToolTipText("Press 'M' to toggle Hex or Decimal Mode");
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 77) {
                    HexOrDecimalInput.this.toggleMode();
                    HexOrDecimalInput.this.repaint();
                }
            }
        });
    }

    public Long getValue() {
        return this.currentValue;
    }

    public int getIntValue() {
        if (this.currentValue == null) {
            return 0;
        }
        return this.currentValue.intValue();
    }

    public void setValue(int newValue) {
        this.setValue(Long.valueOf(newValue));
    }

    public void setValue(Long newValue) {
        if (!this.allowsNegative && newValue != null && newValue < 0L) {
            this.currentValue = null;
        }
        this.currentValue = newValue;
        this.updateText();
    }

    private void toggleMode() {
        if (this.isHexMode) {
            this.setDecimalMode();
        } else {
            this.setHexMode();
        }
    }

    public void setHexMode() {
        this.isHexMode = true;
        this.updateText();
    }

    private void updateText() {
        this.setText(this.computeTextForCurrentValue());
    }

    private String computeTextForCurrentValue() {
        if (this.currentValue == null) {
            return "";
        }
        long value = this.currentValue;
        long absValue = value < 0L ? -value : value;
        Object stringValue = this.isHexMode ? Long.toHexString(absValue) : Long.toString(absValue);
        if (value < 0L) {
            stringValue = "-" + (String)stringValue;
        }
        return stringValue;
    }

    public void setDecimalMode() {
        this.isHexMode = false;
        this.updateText();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Font font = Gui.getFont((String)FONT_ID);
        Font savedFont = g.getFont();
        g.setFont(font);
        g.setColor((Color)GThemeDefaults.Colors.Messages.HINT);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        String mode = this.isHexMode ? "Hex" : "Dec";
        int stringWidth = fontMetrics.stringWidth(mode);
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        int x = size.width - insets.right - stringWidth;
        int y = size.height - insets.bottom;
        GraphicsUtils.drawString((JComponent)this, g, mode, x, y);
        g.setFont(savedFont);
    }

    public void setAllowNegative(boolean b) {
        this.allowsNegative = b;
        if (!this.allowsNegative && this.currentValue != null && this.currentValue < 0L) {
            this.currentValue = null;
        }
        this.updateText();
    }

    private Long computeValueFromString(String text) {
        if (text.length() == 0) {
            return null;
        }
        boolean isNegative = false;
        long value = 0L;
        if (text.startsWith("-")) {
            isNegative = true;
            text = text.substring(1);
        }
        value = this.isHexMode ? Long.parseUnsignedLong(text, 16) : Long.parseLong(text);
        if (isNegative) {
            value = -value;
        }
        return value;
    }

    private class MyDocument
    extends PlainDocument {
        private MyDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (!this.checkChars(str)) {
                return;
            }
            StringBuilder builder = new StringBuilder(HexOrDecimalInput.this.getText());
            builder.insert(offs, str);
            String newText = builder.toString();
            int lastIndexOf = newText.lastIndexOf(45);
            if (lastIndexOf > 0) {
                return;
            }
            if (!newText.equals("-")) {
                try {
                    HexOrDecimalInput.this.currentValue = HexOrDecimalInput.this.computeValueFromString(newText);
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            super.insertString(offs, str, a);
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            super.remove(offs, len);
            String newText = HexOrDecimalInput.this.getText();
            HexOrDecimalInput.this.currentValue = newText.length() == 0 || newText.equals("-") ? null : HexOrDecimalInput.this.computeValueFromString(newText);
        }

        private boolean checkChars(String text) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (this.checkChar(c)) continue;
                return false;
            }
            return true;
        }

        private boolean checkChar(char c) {
            if (HexOrDecimalInput.this.allowsNegative && c == '-') {
                return true;
            }
            if (c >= '0' && c <= '9') {
                return true;
            }
            if (HexOrDecimalInput.this.isHexMode && c >= 'a' && c <= 'f') {
                return true;
            }
            return HexOrDecimalInput.this.isHexMode && c >= 'A' && c <= 'F';
        }
    }
}

