/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.DockingWindowManager;
import docking.widgets.EmptyBorderButton;
import docking.widgets.filter.FilterListener;
import docking.widgets.filter.FilterOptions;
import docking.widgets.filter.FilterOptionsEditorDialog;
import docking.widgets.filter.FilterTextField;
import docking.widgets.label.GDLabel;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.CombinedTableFilter;
import docking.widgets.table.DefaultRowFilterTransformer;
import docking.widgets.table.DefaultTableTextFilterFactory;
import docking.widgets.table.GTable;
import docking.widgets.table.RowFilterTransformer;
import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.SortListener;
import docking.widgets.table.SortedTableModel;
import docking.widgets.table.TableFilter;
import docking.widgets.table.TableModelWrapper;
import docking.widgets.table.TableSortState;
import docking.widgets.table.TableTextFilterFactory;
import docking.widgets.table.TableUtils;
import docking.widgets.table.WrappingTableModel;
import docking.widgets.table.columnfilter.ColumnBasedTableFilter;
import docking.widgets.table.columnfilter.ColumnFilterManager;
import ghidra.framework.options.PreferenceState;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.task.SwingUpdateManager;
import help.HelpService;
import java.awt.Component;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import org.jdom.Attribute;
import org.jdom.Element;
import utilities.util.reflection.ReflectionUtilities;
import utility.function.Callback;

public class GTableFilterPanel<ROW_OBJECT>
extends JPanel {
    public static final String FILTER_TEXTFIELD_NAME = "filter.panel.textfield";
    private static final String FILTER_STATE = "FILTER_STATE";
    private static final String FILTER_EXTENSION = ".FilterExtension";
    private JTable table;
    private RowObjectFilterModel<ROW_OBJECT> rowObjectFilterModel;
    private JLabel searchLabel;
    private FilterTextField filterField;
    private FilterListener filterListener = new GTableFilterListener();
    private static final FilterOptions DEFAULT_OPTIONS = new FilterOptions();
    private FilterOptions filterOptions = DEFAULT_OPTIONS;
    private TableTextFilterFactory<ROW_OBJECT> filterFactory = new DefaultTableTextFilterFactory(this.filterOptions);
    private RowFilterTransformer<ROW_OBJECT> transformer;
    private TableFilter<ROW_OBJECT> secondaryTableFilter;
    private EmptyBorderButton filterStateButton;
    private boolean isFilterDisplayed = true;
    private ColumnFilterManager<ROW_OBJECT> columnFilterManager;
    private String uniquePreferenceKey;
    private SwingUpdateManager filterUpdater = new SwingUpdateManager(250, 1000, () -> {
        String text = this.filterField.getText();
        TableFilter<ROW_OBJECT> tableFilter = this.filterFactory.getTableFilter(text, this.transformer);
        this.table.editingCanceled(null);
        ColumnBasedTableFilter<ROW_OBJECT> columnFilter = this.columnFilterManager.getCurrentFilter();
        this.rowObjectFilterModel.setTableFilter(this.getCombinedTableFilter(this.secondaryTableFilter, tableFilter, columnFilter));
    });
    private TableColumnModelListener columnModelListener = new TableColumnModelListener(){

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            GTableFilterPanel.this.filterUpdater.updateLater();
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            GTableFilterPanel.this.filterUpdater.updateLater();
        }
    };
    private PropertyChangeListener badProgrammingPropertyChangeListener = evt -> {
        if (evt.getPropertyName().equals("model")) {
            throw new AssertException("HEY!  You can't change the model once you've made the commitment to use a filter panel!...duh!");
        }
    };

    public GTableFilterPanel(JTable table, RowObjectTableModel<ROW_OBJECT> tableModel) {
        this(table, tableModel, " Filter: ");
    }

    public void setAccessibleNamePrefix(String namePrefix) {
        this.filterField.setAccessibleNamePrefix(namePrefix);
        String filterOptionsPrefix = namePrefix + " Filter Options";
        this.filterStateButton.setName(filterOptionsPrefix + " Button");
        this.filterStateButton.getAccessibleContext().setAccessibleName(filterOptionsPrefix);
        this.filterStateButton.getAccessibleContext().setAccessibleDescription("");
    }

    public GTableFilterPanel(JTable table, RowObjectTableModel<ROW_OBJECT> tableModel, String filterLabel) {
        this.table = table;
        this.uniquePreferenceKey = this.createUniqueFilterPreferenceKey(table);
        this.transformer = new DefaultRowFilterTransformer<ROW_OBJECT>(tableModel, table.getColumnModel());
        this.rowObjectFilterModel = this.installTableModel(tableModel);
        this.columnFilterManager = new ColumnFilterManager<ROW_OBJECT>(table, this.rowObjectFilterModel, this.getPreferenceKey(), () -> ((SwingUpdateManager)this.filterUpdater).updateLater());
        this.buildPanel(filterLabel);
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.addColumnModelListener(this.columnModelListener);
        table.addPropertyChangeListener(this.badProgrammingPropertyChangeListener);
        DockingWindowManager.registerComponentLoadedListener(this, (windowManager, provider) -> this.componentLoaded(windowManager));
        if (table instanceof GTable) {
            GTable gTable = (GTable)table;
            gTable.setTableFilterPanel(this);
        }
    }

    private void componentLoaded(DockingWindowManager windowManager) {
        if (windowManager == null) {
            return;
        }
        PreferenceState preferenceState = windowManager.getPreferenceState(this.uniquePreferenceKey);
        this.loadFromPreferenceState(preferenceState);
        windowManager.registerPreferenceStateSupplier(this.uniquePreferenceKey, () -> this.createPreferenceState());
    }

    private void loadFromPreferenceState(PreferenceState preferenceState) {
        boolean shouldBeDisplayed;
        if (preferenceState == null) {
            return;
        }
        Element element = preferenceState.getXmlElement(FILTER_STATE);
        if (element == null) {
            return;
        }
        this.filterOptions = FilterOptions.restoreFromXML(element);
        this.updateFilterFactory();
        Attribute attribute = element.getAttribute("IS_SHOWING");
        if (attribute != null && (shouldBeDisplayed = Boolean.parseBoolean(attribute.getValue())) != this.isFilterDisplayed) {
            this.doToggleVisibility();
        }
        this.filterUpdater.updateLater();
    }

    private PreferenceState createPreferenceState() {
        if (this.isDefaultFilterOptions()) {
            return null;
        }
        PreferenceState preferenceState = new PreferenceState();
        Element xmlElement = this.filterOptions.toXML();
        xmlElement.setAttribute("IS_SHOWING", Boolean.toString(this.isFilterDisplayed));
        preferenceState.putXmlElement(FILTER_STATE, xmlElement);
        return preferenceState;
    }

    private boolean isDefaultFilterOptions() {
        return this.isFilterDisplayed && DEFAULT_OPTIONS.equals(this.filterOptions);
    }

    protected TableFilter<ROW_OBJECT> getCombinedTableFilter(TableFilter<ROW_OBJECT> filter1, TableFilter<ROW_OBJECT> filter2, TableFilter<ROW_OBJECT> filter3) {
        return new CombinedTableFilter<ROW_OBJECT>(filter1, filter2, filter3);
    }

    public void addFilterChagnedListener(FilterListener l) {
        this.filterField.addFilterListener(l);
    }

    public void addEnterListener(Callback callback) {
        this.filterField.addEnterListener(callback);
    }

    public void setColumnTableFilter(ColumnBasedTableFilter<ROW_OBJECT> newFilter) {
        this.columnFilterManager.setFilter(newFilter);
    }

    public void setFilterRowTransformer(RowFilterTransformer<ROW_OBJECT> transformer) {
        this.transformer = transformer;
        this.filterUpdater.updateLater();
    }

    public void setSecondaryFilter(TableFilter<ROW_OBJECT> tableFilter) {
        this.secondaryTableFilter = tableFilter;
        this.filterUpdater.updateLater();
    }

    public void setFilterOptions(FilterOptions filterOptions) {
        this.filterOptions = filterOptions;
        this.updateFilterFactory();
        this.filterUpdater.updateLater();
    }

    public FilterOptions getFilterOptions() {
        return this.filterOptions;
    }

    public void activate() {
        if (!this.isFilterDisplayed) {
            this.setVisible(true);
            this.isFilterDisplayed = true;
        }
        this.requestFocus();
    }

    public void toggleVisibility() {
        this.doToggleVisibility();
        if (this.isFilterDisplayed) {
            this.requestFocus();
        }
    }

    private void doToggleVisibility() {
        if (this.isFilterDisplayed) {
            this.setFilterText("");
            this.setVisible(false);
            this.isFilterDisplayed = false;
            return;
        }
        this.setVisible(true);
        this.isFilterDisplayed = true;
    }

    private void buildPanel(String filterLabel) {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.searchLabel = new GDLabel(filterLabel);
        this.searchLabel.setToolTipText("Include only table elements that match the given search text");
        this.filterField = new FilterTextField(this.table);
        this.filterField.setName(FILTER_TEXTFIELD_NAME);
        this.filterField.addFilterListener(this.filterListener);
        this.add(this.searchLabel);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.filterField);
        this.add(this.buildFilterStateButton());
        if (this.isTableColumnFilterableModel()) {
            this.add(Box.createHorizontalStrut(5));
            this.add(this.columnFilterManager.getConfigureButton());
        }
        HelpService helpService = DockingWindowManager.getHelpService();
        HelpLocation helpLocation = new HelpLocation("Trees", "Filters");
        helpService.registerHelp((Object)this.filterStateButton, helpLocation);
        helpService.registerHelp((Object)this.searchLabel, helpLocation);
        helpService.registerHelp((Object)this.filterField, helpLocation);
    }

    private JComponent buildFilterStateButton() {
        this.filterStateButton = new EmptyBorderButton(this.filterOptions.getFilterStateIcon());
        this.filterStateButton.addActionListener(e -> {
            FilterOptionsEditorDialog dialog = new FilterOptionsEditorDialog(this.filterOptions);
            DockingWindowManager.showDialog(this, dialog);
            FilterOptions resultFilterOptions = dialog.getResultFilterOptions();
            if (resultFilterOptions != null) {
                this.setFilterOptions(resultFilterOptions);
            }
        });
        this.filterStateButton.setToolTipText("Filter Options");
        this.updateFilterFactory();
        return this.filterStateButton;
    }

    private boolean isTableColumnFilterableModel() {
        return this.table.getModel() instanceof RowObjectFilterModel;
    }

    private void updateFilterFactory() {
        this.filterStateButton.setIcon(this.filterOptions.getFilterStateIcon());
        this.filterStateButton.setToolTipText(this.filterOptions.getFilterDescription());
        this.filterFactory = new DefaultTableTextFilterFactory(this.filterOptions);
    }

    protected RowObjectFilterModel<ROW_OBJECT> installTableModel(RowObjectTableModel<ROW_OBJECT> currentModel) {
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        int selectionMode = selectionModel.getSelectionMode();
        RowObjectFilterModel<ROW_OBJECT> newModel = this.createTextFilterModel(currentModel);
        if (newModel instanceof WrappingTableModel) {
            this.table.setModel(newModel);
            WrappingTableModel wrapper = (WrappingTableModel)((Object)newModel);
            currentModel.addTableModelListener(new TranslatingTableModelListener(wrapper));
        }
        currentModel.addTableModelListener(new UpdateTableModelListener());
        this.table.setSelectionMode(selectionMode);
        return newModel;
    }

    protected RowObjectFilterModel<ROW_OBJECT> createTextFilterModel(RowObjectTableModel<ROW_OBJECT> model) {
        SortedTableModelWrapper newModel = null;
        if (model instanceof RowObjectFilterModel) {
            newModel = (SortedTableModelWrapper)model;
        } else if (model instanceof SortedTableModel) {
            if (model instanceof AbstractSortedTableModel) {
                AbstractSortedTableModel abstractSortedTableModel = (AbstractSortedTableModel)model;
                newModel = new SortedTableModelWrapper(this, this.table, abstractSortedTableModel);
            } else {
                Msg.debug((Object)this, (Object)("You will not get sorting capability while using a " + this.getClass().getSimpleName() + ".  Your table model should be changed to extend " + AbstractSortedTableModel.class.getSimpleName()));
            }
        } else {
            newModel = new TableModelWrapper(model);
        }
        return newModel;
    }

    protected JTable getTable() {
        return this.table;
    }

    public RowObjectFilterModel<ROW_OBJECT> getTableFilterModel() {
        return this.rowObjectFilterModel;
    }

    public void dispose() {
        DockingWindowManager dwm = DockingWindowManager.getInstance(this);
        if (dwm != null) {
            dwm.removePreferenceStateSupplier(this.uniquePreferenceKey);
        }
        TableColumnModel columnModel = this.table.getColumnModel();
        columnModel.removeColumnModelListener(this.columnModelListener);
        this.columnModelListener = null;
        this.columnFilterManager.dispose();
        this.table.removePropertyChangeListener(this.badProgrammingPropertyChangeListener);
        this.filterUpdater.dispose();
        if (this.table instanceof GTable) {
            ((GTable)this.table).dispose();
        }
    }

    public void setFocusComponent(Component component) {
        this.filterField.setFocusComponent(component);
    }

    @Override
    public void requestFocus() {
        this.filterField.requestFocus();
    }

    @Override
    public void setToolTipText(String text) {
        this.searchLabel.setToolTipText(text);
    }

    public void setFilterText(String text) {
        this.filterField.setText(text);
    }

    public String getFilterText() {
        return this.filterField.getText();
    }

    public int getModelRow(int viewRow) {
        if (viewRow < 0) {
            return viewRow;
        }
        return this.rowObjectFilterModel.getModelRow(viewRow);
    }

    public int getViewRow(int modelRow) {
        return this.rowObjectFilterModel.getViewRow(modelRow);
    }

    public ROW_OBJECT getRowObject(int viewRow) {
        Object rowObject = this.rowObjectFilterModel.getRowObject(viewRow);
        return (ROW_OBJECT)rowObject;
    }

    public void setSelectedItem(ROW_OBJECT t) {
        if (t == null) {
            this.table.clearSelection();
            return;
        }
        int viewRow = this.rowObjectFilterModel.getViewIndex(t);
        if (viewRow >= 0) {
            this.table.setRowSelectionInterval(viewRow, viewRow);
            this.scrollToSelectedRow();
        }
    }

    public void setSelectedItems(List<ROW_OBJECT> items) {
        TableUtils.setSelectedItems(this.table, items);
    }

    public void scrollToSelectedRow() {
        int[] selectedRows = this.table.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            return;
        }
        int row = selectedRows[0];
        Rectangle visibleRect = this.getVisibleRect();
        Rectangle cellRect = this.table.getCellRect(row, 0, true);
        cellRect.x = visibleRect.x;
        cellRect.width = visibleRect.width;
        this.table.scrollRectToVisible(cellRect);
    }

    public ROW_OBJECT getSelectedItem() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return (ROW_OBJECT)this.rowObjectFilterModel.getRowObject(row);
    }

    public List<ROW_OBJECT> getSelectedItems() {
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(rows.length);
        for (int row : rows) {
            list.add(this.rowObjectFilterModel.getRowObject(row));
        }
        return list;
    }

    public boolean isInView(ROW_OBJECT o) {
        int rowIndex = this.rowObjectFilterModel.getRowIndex(o);
        return rowIndex >= 0;
    }

    public boolean isFiltered() {
        return this.getRowCount() != this.getUnfilteredRowCount();
    }

    public int getRowCount() {
        return this.rowObjectFilterModel.getRowCount();
    }

    public int getUnfilteredRowCount() {
        return this.rowObjectFilterModel.getUnfilteredRowCount();
    }

    public String createUniqueFilterPreferenceKey(JTable jTable) {
        return GTableFilterPanel.generateFilterPreferenceKey(jTable, FILTER_EXTENSION);
    }

    public ColumnBasedTableFilter<ROW_OBJECT> getColumnTableFilter() {
        return this.columnFilterManager.getCurrentFilter();
    }

    public String getPreferenceKey() {
        return this.uniquePreferenceKey;
    }

    private static String generateFilterPreferenceKey(JTable jTable, String extension) {
        GTable gTable;
        String preferenceKey;
        if (jTable instanceof GTable && (preferenceKey = (gTable = (GTable)jTable).getPreferenceKey()) != null) {
            return preferenceKey + extension;
        }
        return GTableFilterPanel.getInceptionInformationFromTheFirstClassThatIsNotUs();
    }

    private static String getInceptionInformationFromTheFirstClassThatIsNotUs() {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        String filterName = "Filter";
        StackTraceElement[] filteredTrace = ReflectionUtilities.filterStackTrace((StackTraceElement[])stackTrace, (String[])new String[]{filterName});
        String clientName = filteredTrace[0].getClassName();
        return clientName;
    }

    private class GTableFilterListener
    implements FilterListener {
        private GTableFilterListener() {
        }

        @Override
        public void filterChanged(String text) {
            GTableFilterPanel.this.filterUpdater.updateLater();
        }
    }

    private class TranslatingTableModelListener
    implements TableModelListener {
        private WrappingTableModel tableModelWrapper;

        TranslatingTableModelListener(WrappingTableModel tableModelWrapper) {
            this.tableModelWrapper = tableModelWrapper;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.tableModelWrapper.fireTableChanged(this.translateEventForFilter(e));
        }

        private TableModelEvent translateEventForFilter(TableModelEvent event) {
            int rowCount = GTableFilterPanel.this.rowObjectFilterModel.getUnfilteredRowCount();
            if (rowCount == 0) {
                return event;
            }
            int firstRow = event.getFirstRow();
            int lastRow = event.getLastRow();
            if (firstRow == 0 && lastRow == Integer.MAX_VALUE) {
                return event;
            }
            if (firstRow == 0 && lastRow == rowCount - 1) {
                firstRow = 0;
                lastRow = Math.max(0, GTableFilterPanel.this.rowObjectFilterModel.getRowCount() - 1);
            } else {
                firstRow = GTableFilterPanel.this.getViewRow(firstRow);
                lastRow = GTableFilterPanel.this.getViewRow(lastRow);
            }
            return new TableModelEvent(GTableFilterPanel.this.rowObjectFilterModel, firstRow, lastRow, event.getColumn(), event.getType());
        }
    }

    private class UpdateTableModelListener
    implements TableModelListener {
        private boolean isUpdatingModel;

        private UpdateTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (this.isUpdatingModel) {
                return;
            }
            this.isUpdatingModel = true;
            if (GTableFilterPanel.this.rowObjectFilterModel instanceof WrappingTableModel) {
                WrappingTableModel tableModelWrapper = (WrappingTableModel)((Object)GTableFilterPanel.this.rowObjectFilterModel);
                tableModelWrapper.wrappedModelChangedFromTableChangedEvent();
            }
            GTableFilterPanel.this.filterField.alert();
            this.isUpdatingModel = false;
        }
    }

    private class SortedTableModelWrapper
    extends TableModelWrapper<ROW_OBJECT>
    implements SortedTableModel {
        private AbstractSortedTableModel<ROW_OBJECT> sortedModel;

        private SortedTableModelWrapper(GTableFilterPanel gTableFilterPanel, JTable table, AbstractSortedTableModel<ROW_OBJECT> sortedModel) {
            super(sortedModel);
            this.sortedModel = sortedModel;
        }

        @Override
        public int getPrimarySortColumnIndex() {
            return this.sortedModel.getPrimarySortColumnIndex();
        }

        @Override
        public boolean isSortable(int columnIndex) {
            return this.sortedModel.isSortable(columnIndex);
        }

        @Override
        public TableSortState getTableSortState() {
            return this.sortedModel.getTableSortState();
        }

        @Override
        public void setTableSortState(TableSortState tableSortState) {
            this.sortedModel.setTableSortState(tableSortState);
        }

        @Override
        public void addSortListener(SortListener l) {
            this.sortedModel.addSortListener(l);
        }
    }
}

