/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.widgets.tree.GTree;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.framework.model.DomainFile;
import ghidra.plugin.importer.ProjectIndexService;
import ghidra.plugins.fsbrowser.FSBComponentProvider;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.plugins.fsbrowser.FSBRootNode;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class FSBActionContext
extends DefaultActionContext {
    private GTree gTree;

    public FSBActionContext(FSBComponentProvider provider, List<FSBNode> selectedNodes, MouseEvent event, GTree gTree) {
        super((ComponentProvider)provider, selectedNodes, (Component)gTree);
        this.gTree = gTree;
    }

    public FSBComponentProvider getComponentProvider() {
        return (FSBComponentProvider)super.getComponentProvider();
    }

    public List<FSBNode> getContextObject() {
        return this.getSelectedNodes();
    }

    public GTree getSourceComponent() {
        return this.gTree;
    }

    public boolean notBusy() {
        return !this.gTree.isBusy();
    }

    public boolean isBusy() {
        return this.gTree.isBusy();
    }

    public GTree getTree() {
        return this.gTree;
    }

    public boolean hasSelectedNodes() {
        return !this.getSelectedNodes().isEmpty();
    }

    public List<FSBNode> getSelectedNodes() {
        return (List)super.getContextObject();
    }

    public FSRL getFSRL(boolean dirsOk) {
        FSBRootNode fsRootNode;
        List<FSBNode> selectedNodes = this.getSelectedNodes();
        if (selectedNodes.size() != 1) {
            return null;
        }
        FSBNode node = selectedNodes.get(0);
        FSRL fsrl = node.getFSRL();
        if (!dirsOk && node instanceof FSBRootNode && (fsRootNode = (FSBRootNode)node).getContainer() != null) {
            return fsRootNode.getContainer();
        }
        return node.isLeaf() || dirsOk ? fsrl : null;
    }

    public boolean isSelectedAllDirs() {
        List<FSBNode> selectedNodes = this.getSelectedNodes();
        for (FSBNode node : selectedNodes) {
            if (!node.isLeaf()) continue;
            return false;
        }
        return true;
    }

    public FSBNode getSelectedNode() {
        List<FSBNode> selectedNodes = this.getSelectedNodes();
        return selectedNodes.size() == 1 ? selectedNodes.get(0) : null;
    }

    public int getSelectedCount() {
        return this.getSelectedNodes().size();
    }

    private List<FSRL> getFSRLsFromNodes(List<FSBNode> nodes, boolean dirsOk) {
        ArrayList<FSRL> fsrls = new ArrayList<FSRL>();
        for (FSBNode node : nodes) {
            FSRL fsrl = node.getFSRL();
            if (!node.isLeaf() && !dirsOk) {
                boolean canConvertToContainerNode;
                boolean bl = canConvertToContainerNode = node instanceof FSBRootNode && fsrl.getFS().hasContainer();
                if (!canConvertToContainerNode) continue;
                fsrl = fsrl.getFS().getContainer();
            }
            fsrls.add(fsrl);
        }
        return fsrls;
    }

    public List<FSRL> getFSRLs(boolean dirsOk) {
        List<FSBNode> selectedNodes = this.getSelectedNodes();
        return this.getFSRLsFromNodes(selectedNodes, dirsOk);
    }

    public List<FSRL> getFileFSRLs() {
        return this.getFSRLs(false);
    }

    public FSRL getFileFSRL() {
        return this.getFSRL(false);
    }

    public FSRL getLoadableFSRL() {
        FSBNode node = this.getSelectedNode();
        return node != null ? node.getLoadableFSRL() : null;
    }

    public boolean hasSelectedLinkedNodes() {
        ProjectIndexService projectIndex = this.getComponentProvider().getProjectIndex();
        for (FSBNode node : this.getSelectedNodes()) {
            DomainFile df = projectIndex.findFirstByFSRL(node.getFSRL());
            if (df == null) continue;
            return true;
        }
        return false;
    }
}

